/**
 * jquery.layout 1.4.4
 * $Date: 2014-11-29 08:00:00 (Sat, 29 November 2014) $
 * $Rev: 1.0404 $
 *
 * Copyright (c) 2014 Kevin Dalman (http://jquery-dev.com)
 * Based on work by Fabrizio Balliano (http://www.fabrizioballiano.net)
 *
 * Dual licensed under the GPL (http://www.gnu.org/licenses/gpl.html)
 * and MIT (http://www.opensource.org/licenses/mit-license.php) licenses.
 *
 * SEE: http://layout.jquery-dev.com/LICENSE.txt
 *
 * Changelog: http://layout.jquery-dev.com/changelog.cfm
 *
 * Docs: http://layout.jquery-dev.com/documentation.html
 * Tips: http://layout.jquery-dev.com/tips.html
 * Help: http://groups.google.com/group/jquery-ui-layout
 */


(function($){var min=Math.min,max=Math.max,round=Math.floor,isStr=function(e){return $.type(e)==="string"},runPluginCallbacks=function(Instance,a_fn){function g(e){return e}if($.isArray(a_fn))for(var i=0,c=a_fn.length;i<c;i++){var fn=a_fn[i];try{if(isStr(fn))fn=eval(fn);if($.isFunction(fn))g(fn)(Instance)}catch(ex){}}};$.layout={version:"1.4.4",revision:1.0404,browser:{},effects:{slide:{all:{duration:"fast"},north:{direction:"up"},south:{direction:"down"},east:{direction:"right"},west:{direction:"left"}},drop:{all:{duration:"slow"},north:{direction:"up"},south:{direction:"down"},east:{direction:"right"},west:{direction:"left"}},scale:{all:{duration:"fast"}},blind:{},clip:{},explode:{},fade:{},fold:{},puff:{},size:{all:{easing:"swing"}}},config:{optionRootKeys:"effects,panes,north,south,west,east,center".split(","),allPanes:"north,south,west,east,center".split(","),borderPanes:"north,south,west,east".split(","),oppositeEdge:{north:"south",south:"north",east:"west",west:"east"},offscreenCSS:{left:"-99999px",right:"auto"},offscreenReset:"offscreenReset",hidden:{visibility:"hidden"},visible:{visibility:"visible"},resizers:{cssReq:{position:"absolute",padding:0,margin:0,fontSize:"1px",textAlign:"left",overflow:"hidden"},cssDemo:{background:"#DDD",border:"none"}},togglers:{cssReq:{position:"absolute",display:"block",padding:0,margin:0,overflow:"hidden",textAlign:"center",fontSize:"1px",cursor:"pointer",zIndex:1},cssDemo:{background:"#AAA"}},content:{cssReq:{position:"relative"},cssDemo:{overflow:"auto",padding:"10px"},cssDemoPane:{overflow:"hidden",padding:0}},panes:{cssReq:{position:"absolute",margin:0},cssDemo:{padding:"10px",background:"#FFF",border:"1px solid #BBB",overflow:"auto"}},north:{side:"top",sizeType:"Height",dir:"horz",cssReq:{top:0,bottom:"auto",left:0,right:0,width:"auto"}},south:{side:"bottom",sizeType:"Height",dir:"horz",cssReq:{top:"auto",bottom:0,left:0,right:0,width:"auto"}},east:{side:"right",sizeType:"Width",dir:"vert",cssReq:{left:"auto",right:0,top:"auto",bottom:"auto",height:"auto"}},west:{side:"left",sizeType:"Width",dir:"vert",cssReq:{left:0,right:"auto",top:"auto",bottom:"auto",height:"auto"}},center:{dir:"center",cssReq:{left:"auto",right:"auto",top:"auto",bottom:"auto",height:"auto",width:"auto"}}},callbacks:{},getParentPaneElem:function(e){var t=$(e),n=t.data("layout")||t.data("parentLayout");if(n){var r=n.container;if(r.data("layoutPane"))return r;var i=r.closest("."+$.layout.defaults.panes.paneClass);if(i.data("layoutPane"))return i}return null},getParentPaneInstance:function(e){var t=$.layout.getParentPaneElem(e);return t?t.data("layoutPane"):null},getParentLayoutInstance:function(e){var t=$.layout.getParentPaneElem(e);return t?t.data("parentLayout"):null},getEventObject:function(e){return typeof e==="object"&&e.stopPropagation?e:null},parsePaneName:function(e){var t=$.layout.getEventObject(e),n=e;if(t){t.stopPropagation();n=$(this).data("layoutEdge")}if(n&&!/^(west|east|north|south|center)$/.test(n)){$.layout.msg('LAYOUT ERROR - Invalid pane-name: "'+n+'"');n="error"}return n},plugins:{draggable:!!$.fn.draggable,effects:{core:!!$.effects,slide:$.effects&&($.effects.slide||$.effects.effect&&$.effects.effect.slide)}},onCreate:[],onLoad:[],onReady:[],onDestroy:[],onUnload:[],afterOpen:[],afterClose:[],scrollbarWidth:function(){return window.scrollbarWidth||$.layout.getScrollbarSize("width")},scrollbarHeight:function(){return window.scrollbarHeight||$.layout.getScrollbarSize("height")},getScrollbarSize:function(e){var t=$('<div style="position: absolute; top: -10000px; left: -10000px; width: 100px; height: 100px; border: 0; overflow: scroll;"></div>').appendTo("body"),n={width:t.outerWidth-t[0].clientWidth,height:100-t[0].clientHeight};t.remove();window.scrollbarWidth=n.width;window.scrollbarHeight=n.height;return e.match(/^(width|height)$/)?n[e]:n},disableTextSelection:function(){var e=$(document),t="textSelectionDisabled",n="textSelectionInitialized";if($.fn.disableSelection){if(!e.data(n))e.on("mouseup",$.layout.enableTextSelection).data(n,true);if(!e.data(t))e.disableSelection().data(t,true)}},enableTextSelection:function(){var e=$(document),t="textSelectionDisabled";if($.fn.enableSelection&&e.data(t))e.enableSelection().data(t,false)},showInvisibly:function(e,t){if(e&&e.length&&(t||e.css("display")==="none")){var n=e[0].style,r={display:n.display||"",visibility:n.visibility||""};e.css({display:"block",visibility:"hidden"});return r}return{}},getElementDimensions:function(e,t){var n={css:{},inset:{}},r=n.css,i={bottom:0},s=$.layout.cssNum,o=Math.round,u=e.offset(),a,f,l;n.offsetLeft=u.left;n.offsetTop=u.top;if(!t)t={};$.each("Left,Right,Top,Bottom".split(","),function(s,o){a=r["border"+o]=$.layout.borderWidth(e,o);f=r["padding"+o]=$.layout.cssNum(e,"padding"+o);l=o.toLowerCase();n.inset[l]=t[l]>=0?t[l]:f;i[l]=n.inset[l]+a});r.width=o(e.width());r.height=o(e.height());r.top=s(e,"top",true);r.bottom=s(e,"bottom",true);r.left=s(e,"left",true);r.right=s(e,"right",true);n.outerWidth=o(e.outerWidth());n.outerHeight=o(e.outerHeight());n.innerWidth=max(0,n.outerWidth-i.left-i.right);n.innerHeight=max(0,n.outerHeight-i.top-i.bottom);n.layoutWidth=o(e.innerWidth());n.layoutHeight=o(e.innerHeight());return n},getElementStyles:function(e,t){var n={},r=e[0].style,i=t.split(","),s="Top,Bottom,Left,Right".split(","),o="Color,Style,Width".split(","),u,a,f,l,c,h;for(l=0;l<i.length;l++){u=i[l];if(u.match(/(border|padding|margin)$/))for(c=0;c<4;c++){a=s[c];if(u==="border")for(h=0;h<3;h++){f=o[h];n[u+a+f]=r[u+a+f]}else n[u+a]=r[u+a]}else n[u]=r[u]}return n},cssWidth:function(e,t){if(t<=0)return 0;var n=$.layout.browser,r=!n.boxModel?"border-box":n.boxSizing?e.css("boxSizing"):"content-box",i=$.layout.borderWidth,s=$.layout.cssNum,o=t;if(r!=="border-box")o-=i(e,"Left")+i(e,"Right");if(r==="content-box")o-=s(e,"paddingLeft")+s(e,"paddingRight");return max(0,o)},cssHeight:function(e,t){if(t<=0)return 0;var n=$.layout.browser,r=!n.boxModel?"border-box":n.boxSizing?e.css("boxSizing"):"content-box",i=$.layout.borderWidth,s=$.layout.cssNum,o=t;if(r!=="border-box")o-=i(e,"Top")+i(e,"Bottom");if(r==="content-box")o-=s(e,"paddingTop")+s(e,"paddingBottom");return max(0,o)},cssNum:function(e,t,n){if(!e.jquery)e=$(e);var r=$.layout.showInvisibly(e),i=$.css(e[0],t,true),s=n&&i=="auto"?i:Math.round(parseFloat(i)||0);e.css(r);return s},borderWidth:function(e,t){if(e.jquery)e=e[0];var n="border"+t.substr(0,1).toUpperCase()+t.substr(1);return $.css(e,n+"Style",true)==="none"?0:Math.round(parseFloat($.css(e,n+"Width",true))||0)},isMouseOverElem:function(e,t){var n=$(t||this),r=n.offset(),i=r.top,s=r.left,o=s+n.outerWidth(),u=i+n.outerHeight(),a=e.pageX,f=e.pageY;return $.layout.browser.msie&&a<0&&f<0||a>=s&&a<=o&&f>=i&&f<=u},msg:function(e,t,n,r){function a(){var e=$.support.fixedPosition?"fixed":"absolute",t=$('<div id="layoutLogger" style="position: '+e+'; top: 5px; z-index: 999999; max-width: 25%; overflow: hidden; border: 1px solid #000; border-radius: 5px; background: #FBFBFB; box-shadow: 0 2px 10px rgba(0,0,0,0.3);">'+'<div style="font-size: 13px; font-weight: bold; padding: 5px 10px; background: #F6F6F6; border-radius: 5px 5px 0 0; cursor: move;">'+'<span style="float: right; padding-left: 7px; cursor: pointer;" title="Remove Console" onclick="$(this).closest(\'#layoutLogger\').remove()">X</span>Layout console.log</div>'+'<ul style="font-size: 13px; font-weight: none; list-style: none; margin: 0; padding: 0 0 2px;"></ul>'+"</div>").appendTo("body");t.css("left",$(window).width()-t.outerWidth()-5);if($.ui.draggable)t.draggable({handle:":first-child"});return t}if($.isPlainObject(e)&&window.debugData){if(typeof t==="string"){r=n;n=t}else if(typeof n==="object"){r=n;n=null}var i=n||"log( <object> )",s=$.extend({sort:false,returnHTML:false,display:false},r);if(t===true||s.display)debugData(e,i,s);else if(window.console)console.log(debugData(e,i,s))}else if(t)alert(e);else if(window.console)console.log(e);else{var o="#layoutLogger",u=$(o);if(!u.length)u=a();u.children("ul").append('<li style="padding: 4px 10px; margin: 0; border-top: 1px solid #CCC;">'+e.replace(/\</g,"&lt;").replace(/\>/g,"&gt;")+"</li>")}}};(function(){var e=navigator.userAgent.toLowerCase(),t=/(chrome)[ \/]([\w.]+)/.exec(e)||/(webkit)[ \/]([\w.]+)/.exec(e)||/(opera)(?:.*version|)[ \/]([\w.]+)/.exec(e)||/(msie) ([\w.]+)/.exec(e)||e.indexOf("compatible")<0&&/(mozilla)(?:.*? rv:([\w.]+)|)/.exec(e)||[],n=t[1]||"",r=t[2]||0,i=n==="msie",s=document.compatMode,o=$.support,u=o.boxSizing!==undefined?o.boxSizing:o.boxSizingReliable,a=!i||!s||s==="CSS1Compat"||o.boxModel||false,f=$.layout.browser={version:r,safari:n==="webkit",webkit:n==="chrome",msie:i,isIE6:i&&r==6,boxModel:a,boxSizing:!!(typeof u==="function"?u():u)};if(n)f[n]=true;if(!a&&!s)$(function(){f.boxModel=o.boxModel})})();$.layout.defaults={name:"",containerClass:"ui-layout-container",inset:null,scrollToBookmarkOnLoad:true,resizeWithWindow:true,resizeWithWindowDelay:200,resizeWithWindowMaxDelay:0,maskPanesEarly:false,onresizeall_start:null,onresizeall_end:null,onload_start:null,onload_end:null,onunload_start:null,onunload_end:null,initPanes:true,showErrorMessages:true,showDebugMessages:false,zIndex:null,zIndexes:{pane_normal:0,content_mask:1,resizer_normal:2,pane_sliding:100,pane_animate:1e3,resizer_drag:1e4},errors:{pane:"pane",selector:"selector",addButtonError:"Error Adding Button\nInvalid ",containerMissing:"UI Layout Initialization Error\nThe specified layout-container does not exist.",centerPaneMissing:"UI Layout Initialization Error\nThe center-pane element does not exist.\nThe center-pane is a required element.",noContainerHeight:"UI Layout Initialization Warning\nThe layout-container \"CONTAINER\" has no height.\nTherefore the layout is 0-height and hence 'invisible'!",callbackError:"UI Layout Callback Error\nThe EVENT callback is not a valid function."},panes:{applyDemoStyles:false,closable:true,resizable:true,slidable:true,initClosed:false,initHidden:false,contentSelector:".ui-layout-content",contentIgnoreSelector:".ui-layout-ignore",findNestedContent:false,paneClass:"ui-layout-pane",resizerClass:"ui-layout-resizer",togglerClass:"ui-layout-toggler",buttonClass:"ui-layout-button",minSize:0,maxSize:0,spacing_open:6,spacing_closed:6,togglerLength_open:50,togglerLength_closed:50,togglerAlign_open:"center",togglerAlign_closed:"center",togglerContent_open:"",togglerContent_closed:"",resizerDblClickToggle:true,autoResize:true,autoReopen:true,resizerDragOpacity:1,maskContents:false,maskObjects:false,maskZindex:null,resizingGrid:false,livePaneResizing:false,liveContentResizing:false,liveResizingTolerance:1,sliderCursor:"pointer",slideTrigger_open:"click",slideTrigger_close:"mouseleave",slideDelay_open:300,slideDelay_close:300,hideTogglerOnSlide:false,preventQuickSlideClose:$.layout.browser.webkit,preventPrematureSlideClose:false,tips:{Open:"Open",Close:"Close",Resize:"Resize",Slide:"Slide Open",Pin:"Pin",Unpin:"Un-Pin",noRoomToOpen:"Not enough room to show this panel.",minSizeWarning:"Panel has reached its minimum size",maxSizeWarning:"Panel has reached its maximum size"},showOverflowOnHover:false,enableCursorHotkey:true,customHotkeyModifier:"SHIFT",fxName:"slide",fxSpeed:null,fxSettings:{},fxOpacityFix:true,animatePaneSizing:false,children:null,containerSelector:"",initChildren:true,destroyChildren:true,resizeChildren:true,triggerEventsOnLoad:false,triggerEventsDuringLiveResize:true,onshow_start:null,onshow_end:null,onhide_start:null,onhide_end:null,onopen_start:null,onopen_end:null,onclose_start:null,onclose_end:null,onresize_start:null,onresize_end:null,onsizecontent_start:null,onsizecontent_end:null,onswap_start:null,onswap_end:null,ondrag_start:null,ondrag_end:null},north:{paneSelector:".ui-layout-north",size:"auto",resizerCursor:"n-resize",customHotkey:""},south:{paneSelector:".ui-layout-south",size:"auto",resizerCursor:"s-resize",customHotkey:""},east:{paneSelector:".ui-layout-east",size:200,resizerCursor:"e-resize",customHotkey:""},west:{paneSelector:".ui-layout-west",size:200,resizerCursor:"w-resize",customHotkey:""},center:{paneSelector:".ui-layout-center",minWidth:0,minHeight:0}};$.layout.optionsMap={layout:("name,instanceKey,stateManagement,effects,inset,zIndexes,errors,"+"zIndex,scrollToBookmarkOnLoad,showErrorMessages,maskPanesEarly,"+"outset,resizeWithWindow,resizeWithWindowDelay,resizeWithWindowMaxDelay,"+"onresizeall,onresizeall_start,onresizeall_end,onload,onload_start,onload_end,onunload,onunload_start,onunload_end").split(","),center:("paneClass,contentSelector,contentIgnoreSelector,findNestedContent,applyDemoStyles,triggerEventsOnLoad,"+"showOverflowOnHover,maskContents,maskObjects,liveContentResizing,"+"containerSelector,children,initChildren,resizeChildren,destroyChildren,"+"onresize,onresize_start,onresize_end,onsizecontent,onsizecontent_start,onsizecontent_end").split(","),noDefault:"paneSelector,resizerCursor,customHotkey".split(",")};$.layout.transformData=function(e,t){var n=t?{panes:{},center:{}}:{},r,i,s,o,u,a,f;if(typeof e!=="object")return n;for(i in e){r=n;u=e[i];s=i.split("__");f=s.length-1;for(a=0;a<=f;a++){o=s[a];if(a===f){if($.isPlainObject(u))r[o]=$.layout.transformData(u);else r[o]=u}else{if(!r[o])r[o]={};r=r[o]}}}return n};$.layout.backwardCompatibility={map:{applyDefaultStyles:"applyDemoStyles",childOptions:"children",initChildLayout:"initChildren",destroyChildLayout:"destroyChildren",resizeChildLayout:"resizeChildren",resizeNestedLayout:"resizeChildren",resizeWhileDragging:"livePaneResizing",resizeContentWhileDragging:"liveContentResizing",triggerEventsWhileDragging:"triggerEventsDuringLiveResize",maskIframesOnResize:"maskContents",useStateCookie:"stateManagement.enabled","cookie.autoLoad":"stateManagement.autoLoad","cookie.autoSave":"stateManagement.autoSave","cookie.keys":"stateManagement.stateKeys","cookie.name":"stateManagement.cookie.name","cookie.domain":"stateManagement.cookie.domain","cookie.path":"stateManagement.cookie.path","cookie.expires":"stateManagement.cookie.expires","cookie.secure":"stateManagement.cookie.secure",noRoomToOpenTip:"tips.noRoomToOpen",togglerTip_open:"tips.Close",togglerTip_closed:"tips.Open",resizerTip:"tips.Resize",sliderTip:"tips.Slide"},renameOptions:function(e){function o(t,n){var r=t.split("."),i=r.length-1,s={branch:e,key:r[i]},o=0,u,a;for(;o<i;o++){u=r[o];if(s.branch[u]==undefined){if(n){s.branch=s.branch[u]={}}else s.branch={}}else s.branch=s.branch[u]}return s}var t=$.layout.backwardCompatibility.map,n,r,i;for(var s in t){n=o(s);i=n.branch[n.key];if(i!==undefined){r=o(t[s],true);r.branch[r.key]=i;delete n.branch[n.key]}}},renameAllOptions:function(e){var t=$.layout.backwardCompatibility.renameOptions;t(e);if(e.defaults){if(typeof e.panes!=="object")e.panes={};$.extend(true,e.panes,e.defaults);delete e.defaults}if(e.panes)t(e.panes);$.each($.layout.config.allPanes,function(n,r){if(e[r])t(e[r])});return e}};$.fn.layout=function(opts){function keyDown(e){if(!e)return true;var t=e.keyCode;if(t<33)return true;var n={38:"north",40:"south",37:"west",39:"east"},r=e.altKey,i=e.shiftKey,s=e.ctrlKey,o=s&&t>=37&&t<=40,u,a,f,l;if(o&&options[n[t]].enableCursorHotkey)l=n[t];else if(s||i)$.each(_c.borderPanes,function(e,n){u=options[n];a=u.customHotkey;f=u.customHotkeyModifier;if(i&&f=="SHIFT"||s&&f=="CTRL"||s&&i){if(a&&t===(isNaN(a)||a<=9?a.toUpperCase().charCodeAt(0):a)){l=n;return false}}});if(!l||!$Ps[l]||!options[l].closable||state[l].isHidden)return true;toggle(l);e.stopPropagation();e.returnValue=false;return false}function allowOverflow(e){if(!isInitialized())return;if(this&&this.tagName)e=this;var t;if(isStr(e))t=$Ps[e];else if($(e).data("layoutRole"))t=$(e);else $(e).parents().each(function(){if($(this).data("layoutRole")){t=$(this);return false}});if(!t||!t.length)return;var n=t.data("layoutEdge"),r=state[n];if(r.cssSaved)resetOverflow(n);if(r.isSliding||r.isResizing||r.isClosed){r.cssSaved=false;return}var i={zIndex:options.zIndexes.resizer_normal+1},s={},o=t.css("overflow"),u=t.css("overflowX"),a=t.css("overflowY");if(o!="visible"){s.overflow=o;i.overflow="visible"}if(u&&!u.match(/(visible|auto)/)){s.overflowX=u;i.overflowX="visible"}if(a&&!a.match(/(visible|auto)/)){s.overflowY=u;i.overflowY="visible"}r.cssSaved=s;t.css(i);$.each(_c.allPanes,function(e,t){if(t!=n)resetOverflow(t)})}function resetOverflow(e){if(!isInitialized())return;if(this&&this.tagName)e=this;var t;if(isStr(e))t=$Ps[e];else if($(e).data("layoutRole"))t=$(e);else $(e).parents().each(function(){if($(this).data("layoutRole")){t=$(this);return false}});if(!t||!t.length)return;var n=t.data("layoutEdge"),r=state[n],i=r.cssSaved||{};if(!r.isSliding&&!r.isResizing)t.css("zIndex",options.zIndexes.pane_normal);t.css(i);r.cssSaved=false}var browser=$.layout.browser,_c=$.layout.config,cssW=$.layout.cssWidth,cssH=$.layout.cssHeight,elDims=$.layout.getElementDimensions,styles=$.layout.getElementStyles,evtObj=$.layout.getEventObject,evtPane=$.layout.parsePaneName,options=$.extend(true,{},$.layout.defaults),effects=options.effects=$.extend(true,{},$.layout.effects),state={id:"layout"+$.now(),initialized:false,paneResizing:false,panesSliding:{},container:{innerWidth:0,innerHeight:0,outerWidth:0,outerHeight:0,layoutWidth:0,layoutHeight:0},north:{childIdx:0},south:{childIdx:0},east:{childIdx:0},west:{childIdx:0},center:{childIdx:0}},children={north:null,south:null,east:null,west:null,center:null},timer={data:{},set:function(e,t,n){timer.clear(e);timer.data[e]=setTimeout(t,n)},clear:function(e){var t=timer.data;if(t[e]){clearTimeout(t[e]);delete t[e]}}},_log=function(e,t,n){var r=options;if(r.showErrorMessages&&!n||n&&r.showDebugMessages)$.layout.msg(r.name+" / "+e,t!==false);return false},_runCallbacks=function(evtName,pane,skipBoundEvents){function g(e){return e}var hasPane=pane&&isStr(pane),s=hasPane?state[pane]:state,o=hasPane?options[pane]:options,lName=options.name,lng=evtName+(evtName.match(/_/)?"":"_end"),shrt=lng.match(/_end$/)?lng.substr(0,lng.length-4):"",fn=o[lng]||o[shrt],retVal="NC",args=[],$P=hasPane?$Ps[pane]:0;if(hasPane&&!$P)return retVal;if(!hasPane&&$.type(pane)==="boolean"){skipBoundEvents=pane;pane=""}if(fn){try{if(isStr(fn)){if(fn.match(/,/)){args=fn.split(","),fn=eval(args[0])}else fn=eval(fn)}if($.isFunction(fn)){if(args.length)retVal=g(fn)(args[1]);else if(hasPane)retVal=g(fn)(pane,$Ps[pane],s,o,lName);else retVal=g(fn)(Instance,s,o,lName)}}catch(ex){_log(options.errors.callbackError.replace(/EVENT/,$.trim((pane||"")+" "+lng)),false);if($.type(ex)==="string"&&string.length)_log("Exception:  "+ex,false)}}if(!skipBoundEvents&&retVal!==false){if(hasPane){o=options[pane];s=state[pane];$P.triggerHandler("layoutpane"+lng,[pane,$P,s,o,lName]);if(shrt)$P.triggerHandler("layoutpane"+shrt,[pane,$P,s,o,lName])}else{$N.triggerHandler("layout"+lng,[Instance,s,o,lName]);if(shrt)$N.triggerHandler("layout"+shrt,[Instance,s,o,lName])}}if(hasPane&&evtName==="onresize_end")resizeChildren(pane+"",true);return retVal;},_fixIframe=function(e){if(browser.mozilla)return;var t=$Ps[e];if(state[e].tagName==="IFRAME")t.css(_c.hidden).css(_c.visible);else t.find("IFRAME").css(_c.hidden).css(_c.visible)},cssSize=function(e,t){var n=_c[e].dir=="horz"?cssH:cssW;return n($Ps[e],t)},cssMinDims=function(e){var t=$Ps[e],n=_c[e].dir,r={minWidth:1001-cssW(t,1e3),minHeight:1001-cssH(t,1e3)};if(n==="horz")r.minSize=r.minHeight;if(n==="vert")r.minSize=r.minWidth;return r},setOuterWidth=function(e,t,n){var r=e,i;if(isStr(e))r=$Ps[e];else if(!e.jquery)r=$(e);i=cssW(r,t);r.css({width:i});if(i>0){if(n&&r.data("autoHidden")&&r.innerHeight()>0){r.show().data("autoHidden",false);if(!browser.mozilla)r.css(_c.hidden).css(_c.visible)}}else if(n&&!r.data("autoHidden"))r.hide().data("autoHidden",true)},setOuterHeight=function(e,t,n){var r=e,i;if(isStr(e))r=$Ps[e];else if(!e.jquery)r=$(e);i=cssH(r,t);r.css({height:i,visibility:"visible"});if(i>0&&r.innerWidth()>0){if(n&&r.data("autoHidden")){r.show().data("autoHidden",false);if(!browser.mozilla)r.css(_c.hidden).css(_c.visible)}}else if(n&&!r.data("autoHidden"))r.hide().data("autoHidden",true)},_parseSize=function(e,t,n){if(!n)n=_c[e].dir;if(isStr(t)&&t.match(/%/))t=t==="100%"?-1:parseInt(t,10)/100;if(t===0)return 0;else if(t>=1)return parseInt(t,10);var r=options,i=0;if(n=="horz")i=sC.innerHeight-($Ps.north?r.north.spacing_open:0)-($Ps.south?r.south.spacing_open:0);else if(n=="vert")i=sC.innerWidth-($Ps.west?r.west.spacing_open:0)-($Ps.east?r.east.spacing_open:0);if(t===-1)return i;else if(t>0)return round(i*t);else if(e=="center")return 0;else{var s=n==="horz"?"height":"width",o=$Ps[e],u=s==="height"?$Cs[e]:false,a=$.layout.showInvisibly(o),f=o.css(s),l=u?u.css(s):0;o.css(s,"auto");if(u)u.css(s,"auto");t=s==="height"?o.outerHeight():o.outerWidth();o.css(s,f).css(a);if(u)u.css(s,l);return t}},getPaneSize=function(e,t){var n=$Ps[e],r=options[e],i=state[e],s=t?r.spacing_open:0,o=t?r.spacing_closed:0;if(!n||i.isHidden)return 0;else if(i.isClosed||i.isSliding&&t)return o;else if(_c[e].dir==="horz")return n.outerHeight()+s;else return n.outerWidth()+s},setSizeLimits=function(e,t){if(!isInitialized())return;var n=options[e],r=state[e],i=_c[e],s=i.dir,o=i.sizeType.toLowerCase(),u=t!=undefined?t:r.isSliding,a=$Ps[e],f=n.spacing_open,l=_c.oppositeEdge[e],c=state[l],h=$Ps[l],p=!h||c.isVisible===false||c.isSliding?0:s=="horz"?h.outerHeight():h.outerWidth(),d=(!h||c.isHidden?0:options[l][c.isClosed!==false?"spacing_closed":"spacing_open"])||0,v=s=="horz"?sC.innerHeight:sC.innerWidth,m=cssMinDims("center"),g=s=="horz"?max(options.center.minHeight,m.minHeight):max(options.center.minWidth,m.minWidth),y=v-f-(u?0:_parseSize("center",g,s)+p+d),b=r.minSize=max(_parseSize(e,n.minSize),cssMinDims(e).minSize),w=r.maxSize=min(n.maxSize?_parseSize(e,n.maxSize):1e5,y),E=r.resizerPosition={},S=sC.inset.top,x=sC.inset.left,T=sC.innerWidth,N=sC.innerHeight,C=n.spacing_open;switch(e){case"north":E.min=S+b;E.max=S+w;break;case"west":E.min=x+b;E.max=x+w;break;case"south":E.min=S+N-w-C;E.max=S+N-b-C;break;case"east":E.min=x+T-w-C;E.max=x+T-b-C;break}},calcNewCenterPaneDims=function(){var e={top:getPaneSize("north",true),bottom:getPaneSize("south",true),left:getPaneSize("west",true),right:getPaneSize("east",true),width:0,height:0};e.width=sC.innerWidth-e.left-e.right;e.height=sC.innerHeight-e.bottom-e.top;e.top+=sC.inset.top;e.bottom+=sC.inset.bottom;e.left+=sC.inset.left;e.right+=sC.inset.right;return e},getHoverClasses=function(e,t){var n=$(e),r=n.data("layoutRole"),i=n.data("layoutEdge"),s=options[i],o=s[r+"Class"],u="-"+i,a="-open",f="-closed",l="-sliding",c="-hover ",h=n.hasClass(o+f)?f:a,p=h===f?a:f,d=o+c+(o+u+c)+(o+h+c)+(o+u+h+c);if(t)d+=o+p+c+(o+u+p+c);if(r=="resizer"&&n.hasClass(o+l))d+=o+l+c+(o+u+l+c);return $.trim(d)},addHover=function(e,t){var n=$(t||this);if(e&&n.data("layoutRole")==="toggler")e.stopPropagation();n.addClass(getHoverClasses(n))},removeHover=function(e,t){var n=$(t||this);n.removeClass(getHoverClasses(n,true))},onResizerEnter=function(e){var t=$(this).data("layoutEdge"),n=state[t],r=$(document);if(n.isResizing||state.paneResizing)return;if(options.maskPanesEarly)showMasks(t,{resizing:true})},onResizerLeave=function(e,t){var n=t||this,r=$(n).data("layoutEdge"),i=r+"ResizerLeave",s=$(document);timer.clear(r+"_openSlider");timer.clear(i);if(!t)timer.set(i,function(){onResizerLeave(e,n)},200);else if(options.maskPanesEarly&&!state.paneResizing)hideMasks()},_create=function(){initOptions();var e=options,t=state;t.creatingLayout=true;runPluginCallbacks(Instance,$.layout.onCreate);if(false===_runCallbacks("onload_start"))return"cancel";_initContainer();initHotkeys();$(window).bind("unload."+sID,unload);runPluginCallbacks(Instance,$.layout.onLoad);if(e.initPanes)_initLayoutElements();delete t.creatingLayout;return state.initialized},isInitialized=function(){if(state.initialized||state.creatingLayout)return true;else return _initLayoutElements()},_initLayoutElements=function(e){var t=options;if(!$N.is(":visible")){if(!e&&browser.webkit&&$N[0].tagName==="BODY")setTimeout(function(){_initLayoutElements(true)},50);return false}if(!getPane("center").length){return _log(t.errors.centerPaneMissing)}state.creatingLayout=true;$.extend(sC,elDims($N,t.inset));initPanes();if(t.scrollToBookmarkOnLoad){var n=self.location;if(n.hash)n.replace(n.hash)}if(Instance.hasParentLayout)t.resizeWithWindow=false;else if(t.resizeWithWindow)$(window).bind("resize."+sID,windowResize);delete state.creatingLayout;state.initialized=true;runPluginCallbacks(Instance,$.layout.onReady);_runCallbacks("onload_end");return true},createChildren=function(e,t){var n=evtPane.call(this,e),r=$Ps[n];if(!r)return;var i=$Cs[n],s=state[n],o=options[n],u=options.stateManagement||{},a=t?o.children=t:o.children;if($.isPlainObject(a))a=[a];else if(!a||!$.isArray(a))return;$.each(a,function(e,t){if(!$.isPlainObject(t))return;var o=t.containerSelector?r.find(t.containerSelector):i||r;o.each(function(){var e=$(this),r=e.data("layout");if(!r){setInstanceKey({container:e,options:t},s);if(u.includeChildren&&state.stateData[n]){var i=state.stateData[n].children||{},o=i[t.instanceKey],a=t.stateManagement||(t.stateManagement={autoLoad:true});if(a.autoLoad===true&&o){a.autoSave=false;a.includeChildren=true;a.autoLoad=$.extend(true,{},o)}}r=e.layout(t);if(r){refreshChildren(n,r)}}})})},setInstanceKey=function(e,t){var n=e.container,r=e.options,i=r.stateManagement,s=r.instanceKey||n.data("layoutInstanceKey");if(!s)s=(i&&i.cookie?i.cookie.name:"")||r.name;if(!s)s="layout"+ ++t.childIdx;else s=s.replace(/[^\w-]/gi,"_").replace(/_{2,}/g,"_");r.instanceKey=s;n.data("layoutInstanceKey",s);return s},refreshChildren=function(e,t){var n=$Ps[e],r=children[e],i=state[e],s;if($.isPlainObject(r)){$.each(r,function(e,t){if(t.destroyed)delete r[e]});if($.isEmptyObject(r))r=children[e]=null}if(!t&&!r){t=n.data("layout")}if(t){t.hasParentLayout=true;s=t.options;setInstanceKey(t,i);if(!r)r=children[e]={};r[s.instanceKey]=t.container.data("layout")}Instance[e].children=children[e];if(!t){createChildren(e)}},windowResize=function(){var e=options,t=Number(e.resizeWithWindowDelay);if(t<10)t=100;timer.clear("winResize");timer.set("winResize",function(){timer.clear("winResize");timer.clear("winResizeRepeater");var t=elDims($N,e.inset);if(t.innerWidth!==sC.innerWidth||t.innerHeight!==sC.innerHeight)resizeAll()},t);if(!timer.data["winResizeRepeater"])setWindowResizeRepeater()},setWindowResizeRepeater=function(){var e=Number(options.resizeWithWindowMaxDelay);if(e>0)timer.set("winResizeRepeater",function(){setWindowResizeRepeater();resizeAll()},e)},unload=function(){var e=options;_runCallbacks("onunload_start");runPluginCallbacks(Instance,$.layout.onUnload);_runCallbacks("onunload_end")},_initContainer=function(){var e=$N[0],t=$("html"),n=sC.tagName=e.tagName,r=sC.id=e.id,i=sC.className=e.className,s=options,o=s.name,u="position,margin,padding,border",a="layoutCSS",f={},l="hidden",c=$N.data("parentLayout"),h=$N.data("layoutEdge"),p=c&&h,d=$.layout.cssNum,v,m;sC.selector=$N.selector.split(".slice")[0];sC.ref=(s.name?s.name+" layout / ":"")+n+(r?"#"+r:i?".["+i+"]":"");sC.isBody=n==="BODY";if(!p&&!sC.isBody){v=$N.closest("."+$.layout.defaults.panes.paneClass);c=v.data("parentLayout");h=v.data("layoutEdge");p=c&&h}$N.data({layout:Instance,layoutContainer:sID}).addClass(s.containerClass);var g={destroy:"",initPanes:"",resizeAll:"resizeAll",resize:"resizeAll"};for(o in g){$N.bind("layout"+o.toLowerCase()+"."+sID,Instance[g[o]||o])}if(p){Instance.hasParentLayout=true;c.refreshChildren(h,Instance)}if(!$N.data(a)){if(sC.isBody){$N.data(a,$.extend(styles($N,u),{height:$N.css("height"),overflow:$N.css("overflow"),overflowX:$N.css("overflowX"),overflowY:$N.css("overflowY")}));t.data(a,$.extend(styles(t,"padding"),{height:"auto",overflow:t.css("overflow"),overflowX:t.css("overflowX"),overflowY:t.css("overflowY")}))}else $N.data(a,styles($N,u+",top,bottom,left,right,width,height,overflow,overflowX,overflowY"))}try{f={overflow:l,overflowX:l,overflowY:l};$N.css(f);if(s.inset&&!$.isPlainObject(s.inset)){m=parseInt(s.inset,10)||0;s.inset={top:m,bottom:m,left:m,right:m}}if(sC.isBody){if(!s.outset){s.outset={top:d(t,"paddingTop"),bottom:d(t,"paddingBottom"),left:d(t,"paddingLeft"),right:d(t,"paddingRight")}}else if(!$.isPlainObject(s.outset)){m=parseInt(s.outset,10)||0;s.outset={top:m,bottom:m,left:m,right:m}}t.css(f).css({height:"100%",border:"none",padding:0,margin:0});if(browser.isIE6){$N.css({width:"100%",height:"100%",border:"none",padding:0,margin:0,position:"relative"});if(!s.inset)s.inset=elDims($N).inset}else{$N.css({width:"auto",height:"auto",margin:0,position:"absolute"});$N.css(s.outset)}$.extend(sC,elDims($N,s.inset))}else{var y=$N.css("position");if(!y||!y.match(/(fixed|absolute|relative)/))$N.css("position","relative");if($N.is(":visible")){$.extend(sC,elDims($N,s.inset));if(sC.innerHeight<1)_log(s.errors.noContainerHeight.replace(/CONTAINER/,sC.ref))}}if(d($N,"minWidth"))$N.parent().css("overflowX","auto");if(d($N,"minHeight"))$N.parent().css("overflowY","auto")}catch(b){}},initHotkeys=function(e){e=e?e.split(","):_c.borderPanes;$.each(e,function(e,t){var n=options[t];if(n.enableCursorHotkey||n.customHotkey){$(document).bind("keydown."+sID,keyDown);return false}})},initOptions=function(){function c(e){var t=options[e],n=options.panes;if(!t.fxSettings)t.fxSettings={};if(!n.fxSettings)n.fxSettings={};$.each(["_open","_close","_size"],function(r,i){var s="fxName"+i,o="fxSpeed"+i,u="fxSettings"+i,a=t[s]=t[s]||n[s]||t.fxName||n.fxName||"none",f=$.effects&&($.effects[a]||$.effects.effect&&$.effects.effect[a]);if(a==="none"||!options.effects[a]||!f)a=t[s]="none";var l=options.effects[a]||{},c=l.all||null,h=l[e]||null;t[o]=t[o]||n[o]||t.fxSpeed||n.fxSpeed||null;t[u]=$.extend(true,{},c,h,n.fxSettings,t.fxSettings,n[u],t[u])});delete t.fxName;delete t.fxSpeed;delete t.fxSettings}var e,t,n,r,i,s,o,u;opts=$.layout.transformData(opts,true);opts=$.layout.backwardCompatibility.renameAllOptions(opts);if(!$.isEmptyObject(opts.panes)){e=$.layout.optionsMap.noDefault;for(s=0,o=e.length;s<o;s++){r=e[s];delete opts.panes[r]}e=$.layout.optionsMap.layout;for(s=0,o=e.length;s<o;s++){r=e[s];delete opts.panes[r]}}e=$.layout.optionsMap.layout;var a=$.layout.config.optionRootKeys;for(r in opts){i=opts[r];if($.inArray(r,a)<0&&$.inArray(r,e)<0){if(!opts.panes[r])opts.panes[r]=$.isPlainObject(i)?$.extend(true,{},i):i;delete opts[r]}}$.extend(true,options,opts);$.each(_c.allPanes,function(n,i){_c[i]=$.extend(true,{},_c.panes,_c[i]);t=options.panes;u=options[i];if(i==="center"){e=$.layout.optionsMap.center;for(n=0,o=e.length;n<o;n++){r=e[n];if(!opts.center[r]&&(opts.panes[r]||!u[r]))u[r]=t[r]}}else{u=options[i]=$.extend(true,{},t,u);c(i);if(!u.resizerClass)u.resizerClass="ui-layout-resizer";if(!u.togglerClass)u.togglerClass="ui-layout-toggler"}if(!u.paneClass)u.paneClass="ui-layout-pane"});var f=opts.zIndex,l=options.zIndexes;if(f>0){l.pane_normal=f;l.content_mask=max(f+1,l.content_mask);l.resizer_normal=max(f+2,l.resizer_normal)}delete options.panes},getPane=function(e){var t=options[e].paneSelector;if(t.substr(0,1)==="#")return $N.find(t).eq(0);else{var n=$N.children(t).eq(0);return n.length?n:$N.children("form:first").children(t).eq(0)}},initPanes=function(e){evtPane(e);$.each(_c.allPanes,function(e,t){addPane(t,true)});initHandles();$.each(_c.borderPanes,function(e,t){if($Ps[t]&&state[t].isVisible){setSizeLimits(t);makePaneFit(t)}});sizeMidPanes("center");$.each(_c.allPanes,function(e,t){afterInitPane(t)})},addPane=function(e,t){if(!t&&!isInitialized())return;var n=options[e],r=state[e],i=_c[e],s=i.dir,o=r.fx,u=n.spacing_open||0,a=e==="center",f={},l=$Ps[e],c,h,p,d;if(l)removePane(e,false,true,false);else $Cs[e]=false;l=$Ps[e]=getPane(e);if(!l.length){$Ps[e]=false;return}if(!l.data("layoutCSS")){var v="position,top,left,bottom,right,width,height,overflow,zIndex,display,backgroundColor,padding,margin,border";l.data("layoutCSS",styles(l,v))}Instance[e]={name:e,pane:$Ps[e],content:$Cs[e],options:options[e],state:state[e],children:children[e]};l.data({parentLayout:Instance,layoutPane:Instance[e],layoutEdge:e,layoutRole:"pane"}).css(i.cssReq).css("zIndex",options.zIndexes.pane_normal).css(n.applyDemoStyles?i.cssDemo:{}).addClass(n.paneClass+" "+n.paneClass+"-"+e).bind("mouseenter."+sID,addHover).bind("mouseleave."+sID,removeHover);var m={hide:"",show:"",toggle:"",close:"",open:"",slideOpen:"",slideClose:"",slideToggle:"",size:"sizePane",sizePane:"sizePane",sizeContent:"",sizeHandles:"",enableClosable:"",disableClosable:"",enableSlideable:"",disableSlideable:"",enableResizable:"",disableResizable:"",swapPanes:"swapPanes",swap:"swapPanes",move:"swapPanes",removePane:"removePane",remove:"removePane",createChildren:"",resizeChildren:"",resizeAll:"resizeAll",resizeLayout:"resizeAll"},g;for(g in m){l.bind("layoutpane"+g.toLowerCase()+"."+sID,Instance[m[g]||g])}initContent(e,false);if(!a){c=r.size=_parseSize(e,n.size);h=_parseSize(e,n.minSize)||1;p=_parseSize(e,n.maxSize)||1e5;if(c>0)c=max(min(c,p),h);r.autoResize=n.autoResize;r.isClosed=false;r.isSliding=false;r.isResizing=false;r.isHidden=false;if(!r.pins)r.pins=[]}r.tagName=l[0].tagName;r.edge=e;r.noRoom=false;r.isVisible=true;setPanePosition(e);if(s==="horz")f.height=cssH(l,c);else if(s==="vert")f.width=cssW(l,c);l.css(f);if(s!="horz")sizeMidPanes(e,true);if(state.initialized){initHandles(e);initHotkeys(e)}if(n.initClosed&&n.closable&&!n.initHidden)close(e,true,true);else if(n.initHidden||n.initClosed)hide(e);else if(!r.noRoom)l.css("display","block");l.css("visibility","visible");if(n.showOverflowOnHover)l.hover(allowOverflow,resetOverflow);if(state.initialized){afterInitPane(e)}},afterInitPane=function(e){var t=$Ps[e],n=state[e],r=options[e];if(!t)return;if(t.data("layout"))refreshChildren(e,t.data("layout"));if(n.isVisible){if(state.initialized)resizeAll();else sizeContent(e);if(r.triggerEventsOnLoad)_runCallbacks("onresize_end",e);else resizeChildren(e,true)}if(r.initChildren&&r.children)createChildren(e)},setPanePosition=function(e){e=e?e.split(","):_c.borderPanes;$.each(e,function(e,t){var n=$Ps[t],r=$Rs[t],i=options[t],s=state[t],o=_c[t].side,u={};if(!n)return;switch(t){case"north":u.top=sC.inset.top;u.left=sC.inset.left;u.right=sC.inset.right;break;case"south":u.bottom=sC.inset.bottom;u.left=sC.inset.left;u.right=sC.inset.right;break;case"west":u.left=sC.inset.left;break;case"east":u.right=sC.inset.right;break;case"center":}n.css(u);if(r&&s.isClosed)r.css(o,sC.inset[o]);else if(r&&!s.isHidden)r.css(o,sC.inset[o]+getPaneSize(t))})},initHandles=function(e){e=e?e.split(","):_c.borderPanes;$.each(e,function(e,t){var n=$Ps[t];$Rs[t]=false;$Ts[t]=false;if(!n)return;var r=options[t],i=state[t],s=_c[t],o=r.paneSelector.substr(0,1)==="#"?r.paneSelector.substr(1):"",u=r.resizerClass,a=r.togglerClass,f=i.isVisible?r.spacing_open:r.spacing_closed,l="-"+t,c=i.isVisible?"-open":"-closed",h=Instance[t],p=h.resizer=$Rs[t]=$("<div></div>"),d=h.toggler=r.closable?$Ts[t]=$("<div></div>"):false;if(!i.isVisible&&r.slidable)p.attr("title",r.tips.Slide).css("cursor",r.sliderCursor);p.attr("id",o?o+"-resizer":"").data({parentLayout:Instance,layoutPane:Instance[t],layoutEdge:t,layoutRole:"resizer"}).css(_c.resizers.cssReq).css("zIndex",options.zIndexes.resizer_normal).css(r.applyDemoStyles?_c.resizers.cssDemo:{}).addClass(u+" "+u+l).hover(addHover,removeHover).hover(onResizerEnter,onResizerLeave).mousedown($.layout.disableTextSelection).mouseup($.layout.enableTextSelection).appendTo($N);if($.fn.disableSelection)p.disableSelection();if(r.resizerDblClickToggle)p.bind("dblclick."+sID,toggle);if(d){d.attr("id",o?o+"-toggler":"").data({parentLayout:Instance,layoutPane:Instance[t],layoutEdge:t,layoutRole:"toggler"}).css(_c.togglers.cssReq).css(r.applyDemoStyles?_c.togglers.cssDemo:{}).addClass(a+" "+a+l).hover(addHover,removeHover).bind("mouseenter",onResizerEnter).appendTo(p);if(r.togglerContent_open)$("<span>"+r.togglerContent_open+"</span>").data({layoutEdge:t,layoutRole:"togglerContent"}).data("layoutRole","togglerContent").data("layoutEdge",t).addClass("content content-open").css("display","none").appendTo(d);if(r.togglerContent_closed)$("<span>"+r.togglerContent_closed+"</span>").data({layoutEdge:t,layoutRole:"togglerContent"}).addClass("content content-closed").css("display","none").appendTo(d);enableClosable(t)}initResizable(t);if(i.isVisible)setAsOpen(t);else{setAsClosed(t);bindStartSlidingEvents(t,true)}});sizeHandles()},initContent=function(e,t){if(!isInitialized())return;var n=options[e],r=n.contentSelector,i=Instance[e],s=$Ps[e],o;if(r)o=i.content=$Cs[e]=n.findNestedContent?s.find(r).eq(0):s.children(r).eq(0);if(o&&o.length){o.data("layoutRole","content");if(!o.data("layoutCSS"))o.data("layoutCSS",styles(o,"height"));o.css(_c.content.cssReq);if(n.applyDemoStyles){o.css(_c.content.cssDemo);s.css(_c.content.cssDemoPane)}if(s.css("overflowX").match(/(scroll|auto)/)){s.css("overflow","hidden")}state[e].content={};if(t!==false)sizeContent(e)}else i.content=$Cs[e]=false},initResizable=function(e){var t=$.layout.plugins.draggable,n;e=e?e.split(","):_c.borderPanes;$.each(e,function(e,n){var i=options[n];if(!t||!$Ps[n]||!i.resizable){i.resizable=false;return true}var s=state[n],o=options.zIndexes,u=_c[n],a=u.dir=="horz"?"top":"left",f=$Ps[n],l=$Rs[n],c=i.resizerClass,h=0,p,d,v=c+"-drag",m=c+"-"+n+"-drag",g=c+"-dragging",y=c+"-"+n+"-dragging",b=c+"-dragging-limit",w=c+"-"+n+"-dragging-limit",E=false;if(!s.isClosed)l.attr("title",i.tips.Resize).css("cursor",i.resizerCursor);l.draggable({containment:$N[0],axis:u.dir=="horz"?"y":"x",delay:0,distance:1,grid:i.resizingGrid,helper:"clone",opacity:i.resizerDragOpacity,addClasses:false,zIndex:o.resizer_drag,start:function(e,t){i=options[n];s=state[n];d=i.livePaneResizing;if(false===_runCallbacks("ondrag_start",n))return false;s.isResizing=true;state.paneResizing=n;timer.clear(n+"_closeSlider");setSizeLimits(n);p=s.resizerPosition;h=t.position[a];l.addClass(v+" "+m);E=false;showMasks(n,{resizing:true})},drag:function(e,t){if(!E){t.helper.addClass(g+" "+y).css({right:"auto",bottom:"auto"}).children().css("visibility","hidden");E=true;if(s.isSliding)$Ps[n].css("zIndex",o.pane_sliding)}var u=0;if(t.position[a]<p.min){t.position[a]=p.min;u=-1}else if(t.position[a]>p.max){t.position[a]=p.max;u=1}if(u){t.helper.addClass(b+" "+w);window.defaultStatus=u>0&&n.match(/(north|west)/)||u<0&&n.match(/(south|east)/)?i.tips.maxSizeWarning:i.tips.minSizeWarning}else{t.helper.removeClass(b+" "+w);window.defaultStatus=""}if(d&&Math.abs(t.position[a]-h)>=i.liveResizingTolerance){h=t.position[a];r(e,t,n)}},stop:function(e,t){$("body").enableSelection();window.defaultStatus="";l.removeClass(v+" "+m);s.isResizing=false;state.paneResizing=false;r(e,t,n,true)}})});var r=function(e,t,n,r){var i=t.position,s=_c[n],o=options[n],u=state[n],a;switch(n){case"north":a=i.top;break;case"west":a=i.left;break;case"south":a=sC.layoutHeight-i.top-o.spacing_open;break;case"east":a=sC.layoutWidth-i.left-o.spacing_open;break}var f=a-sC.inset[s.side];if(!r){if(Math.abs(f-u.size)<o.liveResizingTolerance)return;manualSizePane(n,f,false,true);sizeMasks()}else{if(false!==_runCallbacks("ondrag_end",n))manualSizePane(n,f,false,true);hideMasks(true);if(u.isSliding)showMasks(n,{resizing:true})}}},sizeMask=function(){var e=$(this),t=e.data("layoutMask"),n=state[t];if(n.tagName=="IFRAME"&&n.isVisible)e.css({top:n.offsetTop,left:n.offsetLeft,width:n.outerWidth,height:n.outerHeight})},sizeMasks=function(){$Ms.each(sizeMask)},showMasks=function(e,t){var n=_c[e],r=["center"],i=options.zIndexes,s=$.extend({objectsOnly:false,animation:false,resizing:true,sliding:state[e].isSliding},t),o,u;if(s.resizing)r.push(e);if(s.sliding)r.push(_c.oppositeEdge[e]);if(n.dir==="horz"){r.push("west");r.push("east")}$.each(r,function(e,t){u=state[t];o=options[t];if(u.isVisible&&(o.maskObjects||!s.objectsOnly&&o.maskContents)){getMasks(t).each(function(){sizeMask.call(this);this.style.zIndex=u.isSliding?i.pane_sliding+1:i.pane_normal+1;this.style.display="block"})}})},hideMasks=function(e){if(e||!state.paneResizing){$Ms.hide()}else if(!e&&!$.isEmptyObject(state.panesSliding)){var t=$Ms.length-1,n,r;for(;t>=0;t--){r=$Ms.eq(t);n=r.data("layoutMask");if(!options[n].maskObjects){r.hide()}}}},getMasks=function(e){var t=$([]),n,r=0,i=$Ms.length;for(;r<i;r++){n=$Ms.eq(r);if(n.data("layoutMask")===e)t=t.add(n)}if(t.length)return t;else return createMasks(e)},createMasks=function(e){var t=$Ps[e],n=state[e],r=options[e],i=options.zIndexes,s,o,u,a,f;if(!r.maskContents&&!r.maskObjects)return $([]);for(f=0;f<(r.maskObjects?2:1);f++){s=r.maskObjects&&f==0;o=document.createElement(s?"iframe":"div");u=$(o).data("layoutMask",e);o.className="ui-layout-mask ui-layout-mask-"+e;a=o.style;a.background="#FFF";a.position="absolute";a.display="block";if(s){o.src="about:blank";o.frameborder=0;a.border=0;a.opacity=0;a.filter="Alpha(Opacity='0')"}else{a.opacity=.001;a.filter="Alpha(Opacity='1')"}if(n.tagName=="IFRAME"){a.zIndex=i.pane_normal+1;$N.append(o)}else{u.addClass("ui-layout-mask-inside-pane");a.zIndex=r.maskZindex||i.content_mask;a.top=0;a.left=0;a.width="100%";a.height="100%";t.append(o)}$Ms=$Ms.add(o)}return $Ms},destroy=function(e,t){$(window).unbind("."+sID);$(document).unbind("."+sID);if(typeof e==="object")evtPane(e);else t=e;$N.clearQueue().removeData("layout").removeData("layoutContainer").removeClass(options.containerClass).unbind("."+sID);$Ms.remove();$.each(_c.allPanes,function(e,n){removePane(n,false,true,t)});var n="layoutCSS";if($N.data(n)&&!$N.data("layoutRole"))$N.css($N.data(n)).removeData(n);if(sC.tagName==="BODY"&&($N=$("html")).data(n))$N.css($N.data(n)).removeData(n);runPluginCallbacks(Instance,$.layout.onDestroy);unload();for(var r in Instance)if(!r.match(/^(container|options)$/))delete Instance[r];Instance.destroyed=true;return Instance},removePane=function(e,t,n,r){if(!isInitialized())return;var i=evtPane.call(this,e),s=$Ps[i],o=$Cs[i],u=$Rs[i],a=$Ts[i];if(s&&$.isEmptyObject(s.data()))s=false;if(o&&$.isEmptyObject(o.data()))o=false;if(u&&$.isEmptyObject(u.data()))u=false;if(a&&$.isEmptyObject(a.data()))a=false;if(s)s.stop(true,true);var f=options[i],l=state[i],c="layout",h="layoutCSS",p=children[i],d=$.isPlainObject(p)&&!$.isEmptyObject(p),v=r!==undefined?r:f.destroyChildren;if(d&&v){$.each(p,function(e,t){if(!t.destroyed)t.destroy(true);if(t.destroyed)delete p[e]});if($.isEmptyObject(p)){p=children[i]=null;d=false}}if(s&&t&&!d)s.remove();else if(s&&s[0]){var m=f.paneClass,g=m+"-"+i,y="-open",b="-sliding",w="-closed",E=[m,m+y,m+w,m+b,g,g+y,g+w,g+b];$.merge(E,getHoverClasses(s,true));s.removeClass(E.join(" ")).removeData("parentLayout").removeData("layoutPane").removeData("layoutRole").removeData("layoutEdge").removeData("autoHidden").unbind("."+sID);if(d&&o){o.width(o.width());$.each(p,function(e,t){t.resizeAll()})}else if(o)o.css(o.data(h)).removeData(h).removeData("layoutRole");if(!s.data(c))s.css(s.data(h)).removeData(h)}if(a)a.remove();if(u)u.remove();Instance[i]=$Ps[i]=$Cs[i]=$Rs[i]=$Ts[i]=false;l={removed:true};if(!n)resizeAll()},_hidePane=function(e){var t=$Ps[e],n=options[e],r=t[0].style;if(n.useOffscreenClose){if(!t.data(_c.offscreenReset))t.data(_c.offscreenReset,{left:r.left,right:r.right});t.css(_c.offscreenCSS)}else t.hide().removeData(_c.offscreenReset)},_showPane=function(e){var t=$Ps[e],n=options[e],r=_c.offscreenCSS,i=t.data(_c.offscreenReset),s=t[0].style;t.show().removeData(_c.offscreenReset);if(n.useOffscreenClose&&i){if(s.left==r.left)s.left=i.left;if(s.right==r.right)s.right=i.right}},hide=function(e,t){if(!isInitialized())return;var n=evtPane.call(this,e),r=options[n],i=state[n],s=$Ps[n],o=$Rs[n];if(n==="center"||!s||i.isHidden)return;if(state.initialized&&false===_runCallbacks("onhide_start",n))return;i.isSliding=false;delete state.panesSliding[n];if(o)o.hide();if(!state.initialized||i.isClosed){i.isClosed=true;i.isHidden=true;i.isVisible=false;if(!state.initialized)_hidePane(n);sizeMidPanes(_c[n].dir==="horz"?"":"center");if(state.initialized||r.triggerEventsOnLoad)_runCallbacks("onhide_end",n)}else{i.isHiding=true;close(n,false,t)}},show=function(e,t,n,r){if(!isInitialized())return;var i=evtPane.call(this,e),s=options[i],o=state[i],u=$Ps[i],a=$Rs[i];if(i==="center"||!u||!o.isHidden)return;if(false===_runCallbacks("onshow_start",i))return;o.isShowing=true;o.isSliding=false;delete state.panesSliding[i];if(t===false)close(i,true);else open(i,false,n,r)},toggle=function(e,t){if(!isInitialized())return;var n=evtObj(e),r=evtPane.call(this,e),i=state[r];if(n)n.stopImmediatePropagation();if(i.isHidden)show(r);else if(i.isClosed)open(r,!!t);else close(r)},_closePane=function(e,t){var n=$Ps[e],r=state[e];_hidePane(e);r.isClosed=true;r.isVisible=false;if(t)setAsClosed(e)},close=function(e,t,n,r){function v(){f.isMoving=false;bindStartSlidingEvents(i,true);var e=_c.oppositeEdge[i];if(state[e].noRoom){setSizeLimits(e);makePaneFit(e)}if(!r&&(state.initialized||a.triggerEventsOnLoad)){if(!h)_runCallbacks("onclose_end",i);if(h)_runCallbacks("onshow_end",i);if(p)_runCallbacks("onhide_end",i)}}var i=evtPane.call(this,e);if(i==="center")return;if(!state.initialized&&$Ps[i]){_closePane(i,true);return}if(!isInitialized())return;var s=$Ps[i],o=$Rs[i],u=$Ts[i],a=options[i],f=state[i],l=_c[i],c,h,p,d;$N.queue(function(e){if(!s||!a.closable&&!f.isShowing&&!f.isHiding||!t&&f.isClosed&&!f.isShowing)return e();var r=!f.isShowing&&false===_runCallbacks("onclose_start",i);h=f.isShowing;p=f.isHiding;d=f.isSliding;delete f.isShowing;delete f.isHiding;if(r)return e();c=!n&&!f.isClosed&&a.fxName_close!="none";f.isMoving=true;f.isClosed=true;f.isVisible=false;if(p)f.isHidden=true;else if(h)f.isHidden=false;if(f.isSliding)bindStopSlidingEvents(i,false);else sizeMidPanes(_c[i].dir==="horz"?"":"center",false);setAsClosed(i);if(c){lockPaneForFX(i,true);s.hide(a.fxName_close,a.fxSettings_close,a.fxSpeed_close,function(){lockPaneForFX(i,false);if(f.isClosed)v();e()})}else{_hidePane(i);v();e()}})},setAsClosed=function(e){if(!$Rs[e])return;var t=$Ps[e],n=$Rs[e],r=$Ts[e],i=options[e],s=state[e],o=_c[e].side,u=i.resizerClass,a=i.togglerClass,f="-"+e,l="-open",c="-sliding",h="-closed";n.css(o,sC.inset[o]).removeClass(u+l+" "+u+f+l).removeClass(u+c+" "+u+f+c).addClass(u+h+" "+u+f+h);if(s.isHidden)n.hide();if(i.resizable&&$.layout.plugins.draggable)n.draggable("disable").removeClass("ui-state-disabled").css("cursor","default").attr("title","");if(r){r.removeClass(a+l+" "+a+f+l).addClass(a+h+" "+a+f+h).attr("title",i.tips.Open);r.children(".content-open").hide();r.children(".content-closed").css("display","block")}syncPinBtns(e,false);if(state.initialized){sizeHandles()}},open=function(e,t,n,r){function p(){f.isMoving=false;_fixIframe(i);if(!f.isSliding){sizeMidPanes(_c[i].dir=="vert"?"center":"",false)}setAsOpen(i)}if(!isInitialized())return;var i=evtPane.call(this,e),s=$Ps[i],o=$Rs[i],u=$Ts[i],a=options[i],f=state[i],l=_c[i],c,h;if(i==="center")return;$N.queue(function(e){if(!s||!a.resizable&&!a.closable&&!f.isShowing||f.isVisible&&!f.isSliding)return e();if(f.isHidden&&!f.isShowing){e();show(i,true);return}if(f.autoResize&&f.size!=a.size)sizePane(i,a.size,true,true,true);else setSizeLimits(i,t);var o=_runCallbacks("onopen_start",i);if(o==="abort")return e();if(o!=="NC")setSizeLimits(i,t);if(f.minSize>f.maxSize){syncPinBtns(i,false);if(!r&&a.tips.noRoomToOpen)alert(a.tips.noRoomToOpen);return e()}if(t)bindStopSlidingEvents(i,true);else if(f.isSliding)bindStopSlidingEvents(i,false);else if(a.slidable)bindStartSlidingEvents(i,false);f.noRoom=false;makePaneFit(i);h=f.isShowing;delete f.isShowing;c=!n&&f.isClosed&&a.fxName_open!="none";f.isMoving=true;f.isVisible=true;f.isClosed=false;if(h)f.isHidden=false;if(c){lockPaneForFX(i,true);s.show(a.fxName_open,a.fxSettings_open,a.fxSpeed_open,function(){lockPaneForFX(i,false);if(f.isVisible)p();e()})}else{_showPane(i);p();e()}});},setAsOpen=function(e,t){var n=$Ps[e],r=$Rs[e],i=$Ts[e],s=options[e],o=state[e],u=_c[e].side,a=s.resizerClass,f=s.togglerClass,l="-"+e,c="-open",h="-closed",p="-sliding";r.css(u,sC.inset[u]+getPaneSize(e)).removeClass(a+h+" "+a+l+h).addClass(a+c+" "+a+l+c);if(o.isSliding)r.addClass(a+p+" "+a+l+p);else r.removeClass(a+p+" "+a+l+p);removeHover(0,r);if(s.resizable&&$.layout.plugins.draggable)r.draggable("enable").css("cursor",s.resizerCursor).attr("title",s.tips.Resize);else if(!o.isSliding)r.css("cursor","default");if(i){i.removeClass(f+h+" "+f+l+h).addClass(f+c+" "+f+l+c).attr("title",s.tips.Close);removeHover(0,i);i.children(".content-closed").hide();i.children(".content-open").css("display","block")}syncPinBtns(e,!o.isSliding);$.extend(o,elDims(n));if(state.initialized){sizeHandles();sizeContent(e,true)}if(!t&&(state.initialized||s.triggerEventsOnLoad)&&n.is(":visible")){_runCallbacks("onopen_end",e);if(o.isShowing)_runCallbacks("onshow_end",e);if(state.initialized)_runCallbacks("onresize_end",e)}},slideOpen=function(e){function s(){if(!r.isClosed)bindStopSlidingEvents(n,true);else if(!r.isMoving)open(n,true)}if(!isInitialized())return;var t=evtObj(e),n=evtPane.call(this,e),r=state[n],i=options[n].slideDelay_open;if(n==="center")return;if(t)t.stopImmediatePropagation();if(r.isClosed&&t&&t.type==="mouseenter"&&i>0)timer.set(n+"_openSlider",s,i);else s();},slideClose=function(e){function o(){if(i.isClosed)bindStopSlidingEvents(n,false);else if(!i.isMoving)close(n)}if(!isInitialized())return;var t=evtObj(e),n=evtPane.call(this,e),r=options[n],i=state[n],s=i.isMoving?1e3:300;if(n==="center")return;if(i.isClosed||i.isResizing)return;else if(r.slideTrigger_close==="click")o();else if(r.preventQuickSlideClose&&i.isMoving)return;else if(r.preventPrematureSlideClose&&t&&$.layout.isMouseOverElem(t,$Ps[n]))return;else if(t)timer.set(n+"_closeSlider",o,max(r.slideDelay_close,s));else o();},slideToggle=function(e){var t=evtPane.call(this,e);toggle(t,true)},lockPaneForFX=function(e,t){var n=$Ps[e],r=state[e],i=options[e],s=options.zIndexes;if(t){showMasks(e,{animation:true,objectsOnly:true});n.css({zIndex:s.pane_animate});if(e=="south")n.css({top:sC.inset.top+sC.innerHeight-n.outerHeight()});else if(e=="east")n.css({left:sC.inset.left+sC.innerWidth-n.outerWidth()})}else{hideMasks();n.css({zIndex:r.isSliding?s.pane_sliding:s.pane_normal});if(e=="south")n.css({top:"auto"});else if(e=="east"&&!n.css("left").match(/\-99999/))n.css({left:"auto"});if(browser.msie&&i.fxOpacityFix&&i.fxName_open!="slide"&&n.css("filter")&&n.css("opacity")==1)n[0].style.removeAttribute("filter")}},bindStartSlidingEvents=function(e,t){var n=options[e],r=$Ps[e],i=$Rs[e],s=n.slideTrigger_open.toLowerCase();if(!i||t&&!n.slidable)return;if(s.match(/mouseover/))s=n.slideTrigger_open="mouseenter";else if(!s.match(/(click|dblclick|mouseenter)/))s=n.slideTrigger_open="click";if(n.resizerDblClickToggle&&s.match(/click/)){i[t?"unbind":"bind"]("dblclick."+sID,toggle)}i[t?"bind":"unbind"](s+"."+sID,slideOpen).css("cursor",t?n.sliderCursor:"default").attr("title",t?n.tips.Slide:"")},bindStopSlidingEvents=function(e,t){function l(t){timer.clear(e+"_closeSlider");t.stopPropagation()}var n=options[e],r=state[e],i=_c[e],s=options.zIndexes,o=n.slideTrigger_close.toLowerCase(),u=t?"bind":"unbind",a=$Ps[e],f=$Rs[e];timer.clear(e+"_closeSlider");if(t){r.isSliding=true;state.panesSliding[e]=true;bindStartSlidingEvents(e,false)}else{r.isSliding=false;delete state.panesSliding[e]}a.css("zIndex",t?s.pane_sliding:s.pane_normal);f.css("zIndex",t?s.pane_sliding+2:s.resizer_normal);if(!o.match(/(click|mouseleave)/))o=n.slideTrigger_close="mouseleave";f[u](o,slideClose);if(o==="mouseleave"){a[u]("mouseleave."+sID,slideClose);f[u]("mouseenter."+sID,l);a[u]("mouseenter."+sID,l)}if(!t)timer.clear(e+"_closeSlider");else if(o==="click"&&!n.resizable){f.css("cursor",t?n.sliderCursor:"default");f.attr("title",t?n.tips.Close:"")}},makePaneFit=function(e,t,n,r){var i=options[e],s=state[e],o=_c[e],u=$Ps[e],a=$Rs[e],f=o.dir==="vert",l=false;if(e==="center"||f&&s.noVerticalRoom){l=s.maxHeight>=0;if(l&&s.noRoom){_showPane(e);if(a)a.show();s.isVisible=true;s.noRoom=false;if(f)s.noVerticalRoom=false;_fixIframe(e)}else if(!l&&!s.noRoom){_hidePane(e);if(a)a.hide();s.isVisible=false;s.noRoom=true}}if(e==="center"){}else if(s.minSize<=s.maxSize){l=true;if(s.size>s.maxSize)sizePane(e,s.maxSize,n,true,r);else if(s.size<s.minSize)sizePane(e,s.minSize,n,true,r);else if(a&&s.isVisible&&u.is(":visible")){var c=s.size+sC.inset[o.side];if($.layout.cssNum(a,o.side)!=c)a.css(o.side,c)}if(s.noRoom){if(s.wasOpen&&i.closable){if(i.autoReopen)open(e,false,true,true);else s.noRoom=false}else show(e,s.wasOpen,true,true)}}else{if(!s.noRoom){s.noRoom=true;s.wasOpen=!s.isClosed&&!s.isSliding;if(s.isClosed){}else if(i.closable)close(e,true,true);else hide(e,true)}}},manualSizePane=function(e,t,n,r,i){if(!isInitialized())return;var s=evtPane.call(this,e),o=options[s],u=state[s],a=i||o.livePaneResizing&&!u.isResizing;if(s==="center")return;u.autoResize=false;sizePane(s,t,n,r,a)},sizePane=function(e,t,n,r,i){function m(){var e=c==="width"?a.outerWidth():a.outerHeight(),r=[{pane:s,count:1,target:t,actual:e,correct:t===e,attempt:t,cssSize:v}],o=r[0],p={},m="Inaccurate size after resizing the "+s+"-pane.";while(!o.correct){p={pane:s,count:o.count+1,target:t};if(o.actual>t)p.attempt=max(0,o.attempt-(o.actual-t));else p.attempt=max(0,o.attempt+(t-o.actual));p.cssSize=cssSize(s,p.attempt);a.css(c,p.cssSize);p.actual=c=="width"?a.outerWidth():a.outerHeight();p.correct=t===p.actual;if(r.length===1){_log(m,false,true);_log(o,false,true)}_log(p,false,true);if(r.length>3)break;r.push(p);o=r[r.length-1]}u.size=t;$.extend(u,elDims(a));if(u.isVisible&&a.is(":visible")){if(f)f.css(l,t+sC.inset[l]);sizeContent(s)}if(!n&&!h&&state.initialized&&u.isVisible)_runCallbacks("onresize_end",s);if(!n){if(!u.isSliding)sizeMidPanes(_c[s].dir=="horz"?"":"center",h,i);sizeHandles()}var g=_c.oppositeEdge[s];if(t<d&&state[g].noRoom){setSizeLimits(g);makePaneFit(g,false,n)}if(r.length>1)_log(m+"\nSee the Error Console for details.",true,true)}if(!isInitialized())return;var s=evtPane.call(this,e),o=options[s],u=state[s],a=$Ps[s],f=$Rs[s],l=_c[s].side,c=_c[s].sizeType.toLowerCase(),h=u.isResizing&&!o.triggerEventsDuringLiveResize,p=r!==true&&o.animatePaneSizing,d,v;if(s==="center")return;$N.queue(function(e){setSizeLimits(s);d=u.size;t=_parseSize(s,t);t=max(t,_parseSize(s,o.minSize));t=min(t,u.maxSize);if(t<u.minSize){e();makePaneFit(s,false,n);return}if(!i&&t===d)return e();u.newSize=t;if(!n&&state.initialized&&u.isVisible)_runCallbacks("onresize_start",s);v=cssSize(s,t);if(p&&a.is(":visible")){var r=$.layout.effects.size[s]||$.layout.effects.size.all,f=o.fxSettings_size.easing||r.easing,l=options.zIndexes,h={};h[c]=v+"px";u.isMoving=true;a.css({zIndex:l.pane_animate}).show().animate(h,o.fxSpeed_size,f,function(){a.css({zIndex:u.isSliding?l.pane_sliding:l.pane_normal});u.isMoving=false;delete u.newSize;m();e()})}else{a.css(c,v);delete u.newSize;if(a.is(":visible"))m();else{u.size=t}e()}})},sizeMidPanes=function(e,t,n){e=(e?e:"east,west,center").split(",");$.each(e,function(e,r){if(!$Ps[r])return;var i=options[r],s=state[r],o=$Ps[r],u=$Rs[r],a=r=="center",f=true,l={},c=$.layout.showInvisibly(o),h=calcNewCenterPaneDims();$.extend(s,elDims(o));if(r==="center"){if(!n&&s.isVisible&&h.width===s.outerWidth&&h.height===s.outerHeight){o.css(c);return true}$.extend(s,cssMinDims(r),{maxWidth:h.width,maxHeight:h.height});l=h;s.newWidth=l.width;s.newHeight=l.height;l.width=cssW(o,l.width);l.height=cssH(o,l.height);f=l.width>=0&&l.height>=0;if(!state.initialized&&i.minWidth>h.width){var p=i.minWidth-s.outerWidth,d=options.east.minSize||0,v=options.west.minSize||0,m=state.east.size,g=state.west.size,y=m,b=g;if(p>0&&state.east.isVisible&&m>d){y=max(m-d,m-p);p-=m-y}if(p>0&&state.west.isVisible&&g>v){b=max(g-v,g-p);p-=g-b}if(p===0){if(m&&m!=d)sizePane("east",y,true,true,n);if(g&&g!=v)sizePane("west",b,true,true,n);sizeMidPanes("center",t,n);o.css(c);return}}}else{if(s.isVisible&&!s.noVerticalRoom)$.extend(s,elDims(o),cssMinDims(r));if(!n&&!s.noVerticalRoom&&h.height===s.outerHeight){o.css(c);return true}l.top=h.top;l.bottom=h.bottom;s.newSize=h.height;l.height=cssH(o,h.height);s.maxHeight=l.height;f=s.maxHeight>=0;if(!f)s.noVerticalRoom=true}if(f){if(!t&&state.initialized)_runCallbacks("onresize_start",r);o.css(l);if(r!=="center")sizeHandles(r);if(s.noRoom&&!s.isClosed&&!s.isHidden)makePaneFit(r);if(s.isVisible){$.extend(s,elDims(o));if(state.initialized)sizeContent(r)}}else if(!s.noRoom&&s.isVisible)makePaneFit(r);o.css(c);delete s.newSize;delete s.newWidth;delete s.newHeight;if(!s.isVisible)return true;if(r==="center"){var w=browser.isIE6||!browser.boxModel;if($Ps.north&&(w||state.north.tagName=="IFRAME"))$Ps.north.css("width",cssW($Ps.north,sC.innerWidth));if($Ps.south&&(w||state.south.tagName=="IFRAME"))$Ps.south.css("width",cssW($Ps.south,sC.innerWidth))}if(!t&&state.initialized)_runCallbacks("onresize_end",r)})},resizeAll=function(e){var t=sC.innerWidth,n=sC.innerHeight;evtPane(e);if(!$N.is(":visible"))return;if(!state.initialized){_initLayoutElements();return}if(e===true&&$.isPlainObject(options.outset)){$N.css(options.outset)}$.extend(sC,elDims($N,options.inset));if(!sC.outerHeight)return;if(e===true){setPanePosition()}if(false===_runCallbacks("onresizeall_start"))return false;var r=sC.innerHeight<n,i=sC.innerWidth<t,s,o,u;$.each(["south","north","east","west"],function(e,t){if(!$Ps[t])return;o=options[t];u=state[t];if(u.autoResize&&u.size!=o.size)sizePane(t,o.size,true,true,true);else{setSizeLimits(t);makePaneFit(t,false,true,true)}});sizeMidPanes("",true,true);sizeHandles();$.each(_c.allPanes,function(e,t){s=$Ps[t];if(!s)return;if(state[t].isVisible)_runCallbacks("onresize_end",t)});_runCallbacks("onresizeall_end")},resizeChildren=function(e,t){var n=evtPane.call(this,e);if(!options[n].resizeChildren)return;if(!t)refreshChildren(n);var r=children[n];if($.isPlainObject(r)){$.each(r,function(e,t){if(!t.destroyed)t.resizeAll()})}},sizeContent=function(e,t){if(!isInitialized())return;var n=evtPane.call(this,e);n=n?n.split(","):_c.allPanes;$.each(n,function(e,n){function f(e){return max(o.css.paddingBottom,parseInt(e.css("marginBottom"),10)||0)}function l(){var e=options[n].contentIgnoreSelector,t=i.nextAll().not(".ui-layout-mask").not(e||":lt(0)"),r=t.filter(":visible"),s=r.filter(":last");u={top:i[0].offsetTop,height:i.outerHeight(),numFooters:t.length,hiddenFooters:t.length-r.length,spaceBelow:0};u.spaceAbove=u.top;u.bottom=u.top+u.height;if(s.length)u.spaceBelow=s[0].offsetTop+s.outerHeight()-u.bottom+f(s);else u.spaceBelow=f(i)}var r=$Ps[n],i=$Cs[n],s=options[n],o=state[n],u=o.content;if(!r||!i||!r.is(":visible"))return true;if(!i.length){initContent(n,false);if(!i)return}if(false===_runCallbacks("onsizecontent_start",n))return;if(!o.isMoving&&!o.isResizing||s.liveContentResizing||t||u.top==undefined){l();if(u.hiddenFooters>0&&r.css("overflow")==="hidden"){r.css("overflow","visible");l();r.css("overflow","hidden")}}var a=o.innerHeight-(u.spaceAbove-o.css.paddingTop)-(u.spaceBelow-o.css.paddingBottom);if(!i.is(":visible")||u.height!=a){setOuterHeight(i,a,true);u.height=a}if(state.initialized)_runCallbacks("onsizecontent_end",n);})},sizeHandles=function(e){var t=evtPane.call(this,e);t=t?t.split(","):_c.borderPanes;$.each(t,function(e,t){var n=options[t],r=state[t],i=$Ps[t],s=$Rs[t],o=$Ts[t],u;if(!i||!s)return;var a=_c[t].dir,f=r.isClosed?"_closed":"_open",l=n["spacing"+f],c=n["togglerAlign"+f],h=n["togglerLength"+f],p,d,v,m={};if(l===0){s.hide();return}else if(!r.noRoom&&!r.isHidden)s.show();if(a==="horz"){p=sC.innerWidth;r.resizerLength=p;d=$.layout.cssNum(i,"left");s.css({width:cssW(s,p),height:cssH(s,l),left:d>-9999?d:sC.inset.left})}else{p=i.outerHeight();r.resizerLength=p;s.css({height:cssH(s,p),width:cssW(s,l),top:sC.inset.top+getPaneSize("north",true)})}removeHover(n,s);if(o){if(h===0||r.isSliding&&n.hideTogglerOnSlide){o.hide();return}else o.show();if(!(h>0)||h==="100%"||h>p){h=p;v=0}else{if(isStr(c)){switch(c){case"top":case"left":v=0;break;case"bottom":case"right":v=p-h;break;case"middle":case"center":default:v=round((p-h)/2)}}else{var g=parseInt(c,10);if(c>=0)v=g;else v=p-h+g}}if(a==="horz"){var y=cssW(o,h);o.css({width:y,height:cssH(o,l),left:v,top:0});o.children(".content").each(function(){u=$(this);u.css("marginLeft",round((y-u.outerWidth())/2))})}else{var b=cssH(o,h);o.css({height:b,width:cssW(o,l),top:v,left:0});o.children(".content").each(function(){u=$(this);u.css("marginTop",round((b-u.outerHeight())/2))})}removeHover(0,o)}if(!state.initialized&&(n.initHidden||r.isHidden)){s.hide();if(o)o.hide()}})},enableClosable=function(e){if(!isInitialized())return;var t=evtPane.call(this,e),n=$Ts[t],r=options[t];if(!n)return;r.closable=true;n.bind("click."+sID,function(e){e.stopPropagation();toggle(t)}).css("visibility","visible").css("cursor","pointer").attr("title",state[t].isClosed?r.tips.Open:r.tips.Close).show()},disableClosable=function(e,t){if(!isInitialized())return;var n=evtPane.call(this,e),r=$Ts[n];if(!r)return;options[n].closable=false;if(state[n].isClosed)open(n,false,true);r.unbind("."+sID).css("visibility",t?"hidden":"visible").css("cursor","default").attr("title","")},enableSlidable=function(e){if(!isInitialized())return;var t=evtPane.call(this,e),n=$Rs[t];if(!n||!n.data("draggable"))return;options[t].slidable=true;if(state[t].isClosed)bindStartSlidingEvents(t,true)},disableSlidable=function(e){if(!isInitialized())return;var t=evtPane.call(this,e),n=$Rs[t];if(!n)return;options[t].slidable=false;if(state[t].isSliding)close(t,false,true);else{bindStartSlidingEvents(t,false);n.css("cursor","default").attr("title","");removeHover(null,n[0])}},enableResizable=function(e){if(!isInitialized())return;var t=evtPane.call(this,e),n=$Rs[t],r=options[t];if(!n||!n.data("draggable"))return;r.resizable=true;n.draggable("enable");if(!state[t].isClosed)n.css("cursor",r.resizerCursor).attr("title",r.tips.Resize)},disableResizable=function(e){if(!isInitialized())return;var t=evtPane.call(this,e),n=$Rs[t];if(!n||!n.data("draggable"))return;options[t].resizable=false;n.draggable("disable").css("cursor","default").attr("title","");removeHover(null,n[0])},swapPanes=function(e,t){function o(e){var t=$Ps[e],n=$Cs[e];return!t?false:{pane:e,P:t?t[0]:false,C:n?n[0]:false,state:$.extend(true,{},state[e]),options:$.extend(true,{},options[e])}}function u(e,t){if(!e)return;var n=e.P,r=e.C,i=e.pane,o=_c[t],u=$.extend(true,{},state[t]),a=options[t],f={resizerCursor:a.resizerCursor},l,c,h;$.each("fxName,fxSpeed,fxSettings".split(","),function(e,t){f[t+"_open"]=a[t+"_open"];f[t+"_close"]=a[t+"_close"];f[t+"_size"]=a[t+"_size"]});$Ps[t]=$(n).data({layoutPane:Instance[t],layoutEdge:t}).css(_c.hidden).css(o.cssReq);$Cs[t]=r?$(r):false;options[t]=$.extend(true,{},e.options,f);state[t]=$.extend(true,{},e.state);l=new RegExp(a.paneClass+"-"+i,"g");n.className=n.className.replace(l,a.paneClass+"-"+t);initHandles(t);if(o.dir!=_c[i].dir){c=s[t]||0;setSizeLimits(t);c=max(c,state[t].minSize);manualSizePane(t,c,true,true)}else $Rs[t].css(o.side,sC.inset[o.side]+(state[t].isVisible?getPaneSize(t):0));if(e.state.isVisible&&!u.isVisible)setAsOpen(t,true);else{setAsClosed(t);bindStartSlidingEvents(t,true)}e=null}if(!isInitialized())return;var n=evtPane.call(this,e);state[n].edge=t;state[t].edge=n;if(false===_runCallbacks("onswap_start",n)||false===_runCallbacks("onswap_start",t)){state[n].edge=n;state[t].edge=t;return}var r=o(n),i=o(t),s={};s[n]=r?r.state.size:0;s[t]=i?i.state.size:0;$Ps[n]=false;$Ps[t]=false;state[n]={};state[t]={};if($Ts[n])$Ts[n].remove();if($Ts[t])$Ts[t].remove();if($Rs[n])$Rs[n].remove();if($Rs[t])$Rs[t].remove();$Rs[n]=$Rs[t]=$Ts[n]=$Ts[t]=false;u(r,t);u(i,n);r=i=s=null;if($Ps[n])$Ps[n].css(_c.visible);if($Ps[t])$Ps[t].css(_c.visible);resizeAll();_runCallbacks("onswap_end",n);_runCallbacks("onswap_end",t);return;},syncPinBtns=function(e,t){if($.layout.plugins.buttons)$.each(state[e].pins,function(n,r){$.layout.buttons.setPinState(Instance,$(r),e,t)})};var $N=$(this).eq(0);if(!$N.length){return _log(options.errors.containerMissing)}if($N.data("layoutContainer")&&$N.data("layout"))return $N.data("layout");var $Ps={},$Cs={},$Rs={},$Ts={},$Ms=$([]),sC=state.container,sID=state.id;var Instance={options:options,state:state,container:$N,panes:$Ps,contents:$Cs,resizers:$Rs,togglers:$Ts,hide:hide,show:show,toggle:toggle,open:open,close:close,slideOpen:slideOpen,slideClose:slideClose,slideToggle:slideToggle,setSizeLimits:setSizeLimits,_sizePane:sizePane,sizePane:manualSizePane,sizeContent:sizeContent,swapPanes:swapPanes,showMasks:showMasks,hideMasks:hideMasks,initContent:initContent,addPane:addPane,removePane:removePane,createChildren:createChildren,refreshChildren:refreshChildren,enableClosable:enableClosable,disableClosable:disableClosable,enableSlidable:enableSlidable,disableSlidable:disableSlidable,enableResizable:enableResizable,disableResizable:disableResizable,allowOverflow:allowOverflow,resetOverflow:resetOverflow,destroy:destroy,initPanes:isInitialized,resizeAll:resizeAll,runCallbacks:_runCallbacks,hasParentLayout:false,children:children,north:false,south:false,west:false,east:false,center:false};if(_create()==="cancel")return null;else return Instance}})(jQuery);(function(e){if(!e.layout)return;if(!e.ui)e.ui={};e.ui.cookie={acceptsCookies:!!navigator.cookieEnabled,read:function(t){var n=document.cookie,r=n?n.split(";"):[],i,s,o;for(o=0;i=r[o];o++){s=e.trim(i).split("=");if(s[0]==t)return decodeURIComponent(s[1])}return null},write:function(t,n,r){var i="",s="",o=false,u=r||{},a=u.expires||null,f=e.type(a);if(f==="date")s=a;else if(f==="string"&&a>0){a=parseInt(a,10);f="number"}if(f==="number"){s=new Date;if(a>0)s.setDate(s.getDate()+a);else{s.setFullYear(1970);o=true}}if(s)i+=";expires="+s.toUTCString();if(u.path)i+=";path="+u.path;if(u.domain)i+=";domain="+u.domain;if(u.secure)i+=";secure";document.cookie=t+"="+(o?"":encodeURIComponent(n))+i},clear:function(t){e.ui.cookie.write(t,"",{expires:-1})}};if(!e.cookie)e.cookie=function(t,n,r){var i=e.ui.cookie;if(n===null)i.clear(t);else if(n===undefined)return i.read(t);else i.write(t,n,r)};e.layout.plugins.stateManagement=true;e.layout.defaults.stateManagement={enabled:false,autoSave:true,autoLoad:true,animateLoad:true,includeChildren:true,stateKeys:"north.size,south.size,east.size,west.size,"+"north.isClosed,south.isClosed,east.isClosed,west.isClosed,"+"north.isHidden,south.isHidden,east.isHidden,west.isHidden",cookie:{name:"",domain:"",path:"",expires:"",secure:false}};e.layout.optionsMap.layout.push("stateManagement");e.layout.config.optionRootKeys.push("stateManagement");e.layout.state={saveCookie:function(t,n,r){var i=t.options,s=i.stateManagement,o=e.extend(true,{},s.cookie,r||null),u=t.state.stateData=t.readState(n||s.stateKeys);e.ui.cookie.write(o.name||i.name||"Layout",e.layout.state.encodeJSON(u),o);return e.extend(true,{},u)},deleteCookie:function(t){var n=t.options;e.ui.cookie.clear(n.stateManagement.cookie.name||n.name||"Layout")},readCookie:function(t){var n=t.options;var r=e.ui.cookie.read(n.stateManagement.cookie.name||n.name||"Layout");return r?e.layout.state.decodeJSON(r):{}},loadCookie:function(t){var n=e.layout.state.readCookie(t);if(n&&!e.isEmptyObject(n)){t.state.stateData=e.extend(true,{},n);t.loadState(n)}return n},loadState:function(t,n,r){if(!e.isPlainObject(n)||e.isEmptyObject(n))return;n=t.state.stateData=e.layout.transformData(n);var i=t.options.stateManagement;r=e.extend({animateLoad:false,includeChildren:i.includeChildren},r);if(!t.state.initialized){var o=e.extend(true,{},n);e.each(e.layout.config.allPanes,function(e,t){if(o[t])delete o[t].children});e.extend(true,t.options,o)}else{var u=!r.animateLoad,o,a,f,l,c;e.each(e.layout.config.borderPanes,function(r,i){o=n[i];if(!e.isPlainObject(o))return;s=o.size;a=o.initClosed;f=o.initHidden;ar=o.autoResize;l=t.state[i];c=l.isVisible;if(ar)l.autoResize=ar;if(!c)t._sizePane(i,s,false,false,false);if(f===true)t.hide(i,u);else if(a===true)t.close(i,false,u);else if(a===false)t.open(i,false,u);else if(f===false)t.show(i,false,u);if(c)t._sizePane(i,s,false,false,u)});if(r.includeChildren){var h,p;e.each(t.children,function(t,r){h=n[t]?n[t].children:0;if(h&&r){e.each(r,function(e,t){p=h[e];if(t&&p)t.loadState(p)})}})}}},readState:function(t,n){if(e.type(n)==="string")n={keys:n};if(!n)n={};var r=t.options.stateManagement,i=n.includeChildren,s=i!==undefined?i:r.includeChildren,o=n.stateKeys||r.stateKeys,u={isClosed:"initClosed",isHidden:"initHidden"},a=t.state,f=e.layout.config.allPanes,l={},c,h,p,d,v,m,g,y,b,w;if(e.isArray(o))o=o.join(",");o=o.replace(/__/g,".").split(",");for(var E=0,S=o.length;E<S;E++){c=o[E].split(".");h=c[0];p=c[1];if(e.inArray(h,f)<0)continue;d=a[h][p];if(d==undefined)continue;if(p=="isClosed"&&a[h]["isSliding"])d=true;(l[h]||(l[h]={}))[u[p]?u[p]:p]=d}if(s){e.each(f,function(n,r){m=t.children[r];v=a.stateData[r];if(e.isPlainObject(m)&&!e.isEmptyObject(m)){w=l[r]||(l[r]={});if(!w.children)w.children={};e.each(m,function(t,n){if(n.state.initialized)w.children[t]=e.layout.state.readState(n);else if(v&&v.children&&v.children[t]){w.children[t]=e.extend(true,{},v.children[t])}})}})}return l},encodeJSON:function(t){function r(t){var n=[],r=0,i,s,o,u=e.isArray(t);for(i in t){s=t[i];o=typeof s;if(o=="string")s='"'+s+'"';else if(o=="object")s=parse(s);n[r++]=(!u?'"'+i+'":':"")+s}return(u?"[":"{")+n.join(",")+(u?"]":"}")}var n=window.JSON||{};return(n.stringify||r)(t);},decodeJSON:function(t){try{return e.parseJSON?e.parseJSON(t):window["eval"]("("+t+")")||{}}catch(n){return{}}},_create:function(t){var n=e.layout.state,r=t.options,i=r.stateManagement;e.extend(t,{readCookie:function(){return n.readCookie(t)},deleteCookie:function(){n.deleteCookie(t)},saveCookie:function(e,r){return n.saveCookie(t,e,r)},loadCookie:function(){return n.loadCookie(t)},loadState:function(e,r){n.loadState(t,e,r)},readState:function(e){return n.readState(t,e)},encodeJSON:n.encodeJSON,decodeJSON:n.decodeJSON});t.state.stateData={};if(!i.autoLoad)return;if(e.isPlainObject(i.autoLoad)){if(!e.isEmptyObject(i.autoLoad)){t.loadState(i.autoLoad)}}else if(i.enabled){if(e.isFunction(i.autoLoad)){var s={};try{s=i.autoLoad(t,t.state,t.options,t.options.name||"")}catch(o){}if(s&&e.isPlainObject(s)&&!e.isEmptyObject(s))t.loadState(s)}else t.loadCookie()}},_unload:function(t){var n=t.options.stateManagement;if(n.enabled&&n.autoSave){if(e.isFunction(n.autoSave)){try{n.autoSave(t,t.state,t.options,t.options.name||"")}catch(r){}}else t.saveCookie()}}};e.layout.onCreate.push(e.layout.state._create);e.layout.onUnload.push(e.layout.state._unload)})(jQuery);(function(e){if(!e.layout)return;e.layout.plugins.buttons=true;e.layout.defaults.autoBindCustomButtons=false;e.layout.optionsMap.layout.push("autoBindCustomButtons");e.layout.buttons={config:{borderPanes:"north,south,west,east"},init:function(t){var n="ui-layout-button-",r=t.options.name||"",i;e.each("toggle,open,close,pin,toggle-slide,open-slide".split(","),function(s,o){e.each(e.layout.buttons.config.borderPanes.split(","),function(s,u){e("."+n+o+"-"+u).each(function(){i=e(this).data("layoutName")||e(this).attr("layoutName");if(i==undefined||i===r)t.bindButton(this,o,u)})})})},get:function(t,n,r,i){var s=e(n),o=t.options;if(s.length&&e.layout.buttons.config.borderPanes.indexOf(r)>=0){var u=o[r].buttonClass+"-"+i;s.addClass(u+" "+u+"-"+r).data("layoutName",o.name)}return s},bind:function(t,n,r,i){var s=e.layout.buttons;switch(r.toLowerCase()){case"toggle":s.addToggle(t,n,i);break;case"open":s.addOpen(t,n,i);break;case"close":s.addClose(t,n,i);break;case"pin":s.addPin(t,n,i);break;case"toggle-slide":s.addToggle(t,n,i,true);break;case"open-slide":s.addOpen(t,n,i,true);break}return t},addToggle:function(t,n,r,i){e.layout.buttons.get(t,n,r,"toggle").click(function(e){t.toggle(r,!!i);e.stopPropagation()});return t},addOpen:function(t,n,r,i){e.layout.buttons.get(t,n,r,"open").attr("title",t.options[r].tips.Open).click(function(e){t.open(r,!!i);e.stopPropagation()});return t},addClose:function(t,n,r){e.layout.buttons.get(t,n,r,"close").attr("title",t.options[r].tips.Close).click(function(e){t.close(r);e.stopPropagation()});return t},addPin:function(t,n,r){var i=e.layout.buttons.get(t,n,r,"pin");if(i.length){var s=t.state[r];i.click(function(n){e.layout.buttons.setPinState(t,e(this),r,s.isSliding||s.isClosed);if(s.isSliding||s.isClosed)t.open(r);else t.close(r);n.stopPropagation()});e.layout.buttons.setPinState(t,i,r,!s.isClosed&&!s.isSliding);s.pins.push(n)}return t},setPinState:function(e,t,n,r){var i=t.attr("pin");if(i&&r===(i=="down"))return;var s=e.options[n],o=s.tips,u=s.buttonClass+"-pin",a=u+"-"+n,f=u+"-up "+a+"-up",l=u+"-down "+a+"-down";t.attr("pin",r?"down":"up").attr("title",r?o.Unpin:o.Pin).removeClass(r?f:l).addClass(r?l:f)},syncPinBtns:function(t,n,r){e.each(state[n].pins,function(i,s){e.layout.buttons.setPinState(t,e(s),n,r)})},_load:function(t){e.extend(t,{bindButton:function(n,r,i){return e.layout.buttons.bind(t,n,r,i)},addToggleBtn:function(n,r,i){return e.layout.buttons.addToggle(t,n,r,i)},addOpenBtn:function(n,r,i){return e.layout.buttons.addOpen(t,n,r,i)},addCloseBtn:function(n,r){return e.layout.buttons.addClose(t,n,r)},addPinBtn:function(n,r){return e.layout.buttons.addPin(t,n,r)}});for(var n=0;n<4;n++){var r=e.layout.buttons.config.borderPanes[n];t.state[r].pins=[]}if(t.options.autoBindCustomButtons)e.layout.buttons.init(t)},_unload:function(e){}};e.layout.onLoad.push(e.layout.buttons._load)})(jQuery);(function(e){e.layout.plugins.browserZoom=true;e.layout.defaults.browserZoomCheckInterval=1e3;e.layout.optionsMap.layout.push("browserZoomCheckInterval");e.layout.browserZoom={_init:function(t){if(e.layout.browserZoom.ratio()!==false)e.layout.browserZoom._setTimer(t)},_setTimer:function(t){if(t.destroyed)return;var n=t.options,r=t.state,i=t.hasParentLayout?5e3:Math.max(n.browserZoomCheckInterval,100);setTimeout(function(){if(t.destroyed||!n.resizeWithWindow)return;var i=e.layout.browserZoom.ratio();if(i!==r.browserZoom){r.browserZoom=i;t.resizeAll()}e.layout.browserZoom._setTimer(t)},i)},ratio:function(){function l(e,t){return(parseInt(e,10)/parseInt(t,10)*100).toFixed()}var t=window,n=screen,r=document,i=r.documentElement||r.body,s=e.layout.browser,o=s.version,u,a,f;if(!s.msie||o>8)return false;if(n.deviceXDPI&&n.systemXDPI)return l(n.deviceXDPI,n.systemXDPI);if(s.webkit&&(u=r.body.getBoundingClientRect))return l(u.left-u.right,r.body.offsetWidth);if(s.webkit&&(a=t.outerWidth))return l(a,t.innerWidth);if((a=n.width)&&(f=i.clientWidth))return l(a,f);return false}};e.layout.onReady.push(e.layout.browserZoom._init)})(jQuery);(function(e){if(e.effects){e.layout.defaults.panes.useOffscreenClose=false;if(e.layout.plugins)e.layout.plugins.effects.slideOffscreen=true;e.layout.effects.slideOffscreen=e.extend(true,{},e.layout.effects.slide);e.effects.slideOffscreen=function(t){return this.queue(function(){var n=e.effects,r=t.options,i=e(this),s=i.data("layoutEdge"),u=i.data("parentLayout").state,a=u[s].size,f=this.style,l=["top","bottom","left","right"],c=n.setMode(i,r.mode||"show"),h=c=="show",p=r.direction||"left",d=p=="up"||p=="down"?"top":"left",v=p=="up"||p=="left",m=e.layout.config.offscreenCSS||{},g=e.layout.config.offscreenReset,y="offscreenResetTop",b={};b[d]=(h?v?"+=":"-=":v?"-=":"+=")+a;if(h){i.data(y,{top:f.top,bottom:f.bottom});if(v){i.css(d,isNaN(a)?"-"+a:-a)}else{if(p==="right")i.css({left:u.container.layoutWidth,right:"auto"});else i.css({top:u.container.layoutHeight,bottom:"auto"})}if(d==="top")i.css(i.data(g)||{})}else{i.data(y,{top:f.top,bottom:f.bottom});i.data(g,{left:f.left,right:f.right})}i.show().animate(b,{queue:false,duration:t.duration,easing:r.easing,complete:function(){if(i.data(y))i.css(i.data(y)).removeData(y);if(h)i.css(i.data(g)||{}).removeData(g);else i.css(m);if(t.callback)t.callback.apply(this,arguments);i.dequeue()}})})}}})(jQuery)