<?php

class Admins extends CI_Controller {
    
    var $tablename = ADMINS;
    var $primarykey = "AdminID";
    var $primarykey2 = "PLID";
        
    public function index(){               
        $data['current'] = "admins";                       
        $data['customers'] = $this->general->getAllRecordsWhere($this->tablename,array("is_superadmin"=>0),"$this->primarykey","asc");
        $this->load->view(ADMINFOLDER."/admins",$data);
    }
    
    
    public function AddItem(){
        
        
        $this->load->library('form_validation');
         
        $this->form_validation->set_rules('txt_username', 'Username', 'trim|required');
        $this->form_validation->set_rules('txt_email', 'Email', 'trim|required');
        $this->form_validation->set_rules('txt_password', 'Password', 'trim|required|min_length[8]|max_length[12]');
        $this->form_validation->set_rules('txt_password2', 'Password Confirmation', 'required|matches[txt_password]|trim|min_length[8]|max_length[12]');
                
        $data['message'] = "";
		
        if ($this->form_validation->run() == TRUE)
	{
            $username = $this->input->post("txt_username");     
            $email = $this->input->post("txt_email");
            $password = md5($this->input->post("txt_password"));

            
            // check if username is available in database or not
                $Record = $this->general->getRecordWhere($this->tablename, array("username"=>$username));
                    if(count($Record)){	
                        $data['message'] = "Admin existing already !!!";
                    }
                    else {                        
                         $updateData = array(
                            "username"=>$username,
                            "password"=>$password,
                            "email"=>$email,
                            "PLID"=>$this->input->post("txt_plevel"),
                            "is_active"             => $this->input->post("txt_active"),
                            "date_registered"   => date("Y-m-d H:i:s"),
                            "added_by"   => $this->session->userdata("AdminID"),
                            "date_modified"   => date("Y-m-d H:i:s")
                            );

                        $this->general->insertRecord($this->tablename, $updateData, "AdminID");
                        $data['message'] = "Admin Added successfully";
                    }                                                                          
        }
            
            
        $this->load->view(ADMINFOLDER."/addadmin",$data);                
    }
    
    
    public function editItem($id){
        
        
        $this->load->library('form_validation');
         
        $this->form_validation->set_rules('txt_email', 'Email', 'trim|required');
        $this->form_validation->set_rules('txt_password', 'Password', 'trim|min_length[8]|max_length[12]');
        $this->form_validation->set_rules('txt_password2', 'Password Confirmation', 'matches[txt_password]|trim|min_length[8]|max_length[12]');
                
        $data['message'] = "";
		
        if ($this->form_validation->run() == TRUE)
	{
            $email = $this->input->post("txt_email");
            $password = md5($this->input->post("txt_password"));

            
            
            $updateData = array(
                "$this->primarykey" 	=> $id,                
                "email"=>$email,
                "PLID"=>$this->input->post("txt_plevel"),
                "is_active"             => $this->input->post("txt_active"),                
                "date_modified"   => date("Y-m-d H:i:s")
                );
            
            if($password != "")
            {
                $updateData["password"] = $password;
            }
           
                                                               
            $this->general->updateRecord($this->tablename, $updateData, "AdminID");
                                       
            $data['message'] = "Admin updated successfully";
        }
            
        $data['record'] = $this->general->getRecordWhere($this->tablename,array("$this->primarykey"=>$id), "$this->primarykey","desc");            
        $this->load->view(ADMINFOLDER."/editadmin",$data);                
    }
    
                           
    public function delete($id){        
        $newsRecord = $this->general->getRecordWhere($this->tablename, array("$this->primarykey"=>$id));
			if(count($newsRecord)){				                                                                                                                                        
				$this->db->query("DELETE FROM ".$this->tablename." WHERE $this->primarykey = $id");
				$data['message'] = $this->general->generateMessage("Record Deleted Successfully !!!", "green");
			}else{
				$data['message'] = $this->general->generateMessage("No record found with the specified id.", "red");
			}                                            
            $this->index();              
    }
    
    
//    public function indexold(){
//               
//        $this->load->library('form_validation');
//         
//        $this->form_validation->set_rules('txt_username', 'Username', 'trim|required');
//        $this->form_validation->set_rules('txt_password', 'Password', 'trim|required');
//                
//        $data['message'] = "Enter username/password to get access";
//		
//        if ($this->form_validation->run() == TRUE)
//	{
//            $username = $this->input->post("txt_username");
//            $password = md5($this->input->post("txt_password"));
//
//            $adminData = $this->general->getRecordWhere($this->tablename, array("username"=>$username, "password"=>$password));
//
//            if(count($adminData))
//            {
//                if($adminData->is_active){
//                $newdata = array(
//                                   'AdminID'            => $adminData->AdminID,
//                                   'userName'  		=> $username,
//                                   'loggedInTime'       => date("Y-m-d H:i:s")                                   
//                                   );
//                $this->session->set_userdata($newdata);
//
//                $updateData = array(
//                                                "AdminID" 	=> $newdata['AdminID'],
//                                                "date_last_login"   => date("Y-m-d H:i:s")
//                                    );
//                $this->general->updateRecord($this->tablename, $updateData, "AdminID");
//                redirect(ADMINFOLDER."/home");
//                }else{
//                        $data['message'] = "Your account status is In Active by Administrator.";
//                }
//            }
//            else
//            {
//                    $data['message'] = "Invalid credentials provided";
//            }
//        }        
//        $this->load->view(ADMINFOLDER."/login",$data);
//    }
    
    public function editadmin($id){
        $this->load->library('form_validation');
         
        $this->form_validation->set_rules('txt_username', 'Username', 'trim|required');
        $this->form_validation->set_rules('txt_password', 'Password', 'trim|min_length[8]|max_length[12]');
        $this->form_validation->set_rules('txt_password2', 'Password Confirmation', 'matches[txt_password]|trim|min_length[8]|max_length[12]');
                
        $data['message'] = "";
		
        if ($this->form_validation->run() == TRUE)
	{
            $username = $this->input->post("txt_username");            
            $password = md5($this->input->post("txt_password"));

            if($password != "")
            {
                $updateData = array("AdminID" 	=> $id,"username"=>$username, "password"=>$password,"date_modified"   => date("Y-m-d H:i:s"));
            }
            else
            {
                 $updateData = array("AdminID" 	=> $id,"username"=>$username,"date_modified"   => date("Y-m-d H:i:s"));
            }
                        
            $this->general->updateRecord($this->tablename, $updateData, "AdminID");
            
            $newdata = array(                                  
                                   'userName'  		=> $username                                   
                                   );
            $this->session->set_userdata($newdata);
                
            $data['message'] = "Admin updated successfully";
        }
            
            
        $this->load->view(ADMINFOLDER."/editprofile",$data);
    }
        
        
    
}
